/**
 * \file      dia_SrvHandler_USB_PowerSupplyInfoPort.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Feb 10, 2015
 *
 * \copyright Robert Bosch Car Multimedia 2015
 *
 */

#ifndef DIA_SRVHANDLER_USB_POWERSUPPLYINFOPORT_H_
#define DIA_SRVHANDLER_USB_POWERSUPPLYINFOPORT_H_


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DEVICE_MANAGER_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DEVICEMGRUSB_LISTENER__
#include "common/interfaces/dia_IDeviceMGRUSBListener.h"
#endif

enum UsbPortPowerStatus
{
   USB_PORT_POWER_STATUS_OK = 0,
   USB_PORT_POWER_STATUS_OPEN = 1,
   USB_PORT_POWER_STATUS_SHORT = 2,
   USB_PORT_POWER_STATUS_NOT_AVAILABLE = 0xFFU
};

enum UsbPortCurrent
{
   USB_PORT_CURRENT_NOT_AVAILABLE = 0xFFFFU
};

class dia_SrvHandler_USB_PowerSupplyInfoPort
   : public dia_ServiceHandlerUDS,
     public dia_IDeviceMGRListenerImpl,
     public dia_IDeviceMGRUSBListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR( dia_SrvHandler_USB_PowerSupplyInfoPort );

private:
   //! default class constructor - do not define it
   dia_SrvHandler_USB_PowerSupplyInfoPort ();   //lint !e1704 Info 1704, eliminating lint warnings ("Constructor has private access specification")

public:
   //! class constructor
   dia_SrvHandler_USB_PowerSupplyInfoPort ( tCString name, tU8 sid, tU16 did );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   //! value of current through USB port
   virtual void vOnUSBPortCurrent( const std::vector<dia_tUsbPortCurrent>& PortCurrentList );

   // provide error code in case of failure at current read
   virtual void vOnUSBPortCurrentError (const tU32 errCode );

   //! status of USB port
   virtual void vOnUSBPortStates( const std::vector<dia_tUsbPortStates>& PortStatesList );

protected:

   //! send back response to the tester
   virtual void assembleResponse ();

   //! return true if port number is assigned to the instance of class
   virtual bool isValidPort ( dia_eUsbPort portNumer );

   //! class destructor
   virtual ~dia_SrvHandler_USB_PowerSupplyInfoPort(void);

   //! power status of USB port to be sent to the tester (byte#0)
   UsbPortPowerStatus mUsbPortPowerStatus;

   //! current through the USB port in units of milliampere (byte#1 and byte#2)
   tU16 mUsbPortCurrent;

   //! Information about status for all requested values.
   tU8 mReceivedStatusBitMask;
};

#endif /* DIA_SRVHANDLER_USB_POWERSUPPLYINFOPORT_H_ */
