/*
 * dia_SrvHandler_USBDeviceInfo.h
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 */

#ifndef DIA_SRVHANDLER_USBDEVICEINFO_H_
#define DIA_SRVHANDLER_USBDEVICEINFO_H_


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DEVICE_MANAGER_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

#define DIA_MAX_NUM_USB_DEVICES           ((tU8)3)
#define DIA_MAX_USB_PORT_NUMBER           ((tU8)2)

class dia_SrvHandler_USBDeviceInfo
   : public dia_ServiceHandlerUDS,
     public dia_IDeviceMGRListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR( dia_SrvHandler_USBDeviceInfo );

public:
   //! class constructor
   dia_SrvHandler_USBDeviceInfo ( void );

   /**
     * \brief  handle the received request
     *
     *            Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *            The SystemAdapter returns the current states of the USB device and port.
     */
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief     status for the requested USB device info
     */
   virtual void vOnUSBDeviceInfo( const std::vector<dia_tDeviceInfo>& );

   /**
     * \brief     status for the requested USB power status
     */
   virtual void vOnUSBPortStates( const std::vector<dia_tUsbPortStates>&  );

protected:
   // Sending the response after receiving status for all requested values.
   virtual void assembleResponse ();

   // member to store the requested USB device info
   dia_tDeviceInfo moUSBDeviceInfo[DIA_MAX_NUM_USB_DEVICES];

   // member to store the requested USB port status
   dia_tUsbPortStates moUSBPortStates[DIA_MAX_USB_PORT_NUMBER];

   // Correctness of information about port states (false means that information is invalid)
   tBool mbRetCorrectPortStates[DIA_MAX_USB_PORT_NUMBER];

   // Correctness of information about devices (false means that information is invalid)
   tBool mbRetCorrectDevices[DIA_MAX_NUM_USB_DEVICES];

   // Get information about received status for all requested values.
   tU8 mPropStatusBitMask;

   //! class destructor
   virtual ~dia_SrvHandler_USBDeviceInfo(void);

};

#endif /* DIA_SRVHANDLER_USBDEVICEINFO_H_ */
