/*
 * dia_SrvHandler_TunerXM_UPC.cpp
 *
 *  Created on: 16.01.2013
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 61 43

#ifndef DIA_SRVHANDLER_TUNERXM_UPC_H_
#include "dia_SrvHandler_TunerXM_UPC.h"
#endif


#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#define DATA_START 3
#define DATA_LENGTH 12

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerXM_UPC::dia_SrvHandler_TunerXM_UPC ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerXM_UPC",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_SXM_TUNER_UPC /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_UPC::dia_SrvHandler_TunerXM_UPC(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerXM_UPC::~dia_SrvHandler_TunerXM_UPC ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_ITunerXMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerXM_UPC::~dia_SrvHandler_TunerXM_UPC !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_TunerXM_UPC::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_UPC::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerXM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerXM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerXM_UPC::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerXM_UPC::vProcessRequest - pInterface OK.");
         (void) setSysAdapterListener<dia_ITunerXMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerXM_UPC::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerXM_XM_UPC_Get() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerXM_UPC::vProcessRequest - pInterface->tunerXM_XM_UPC_Get() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerXM_UPC::vProcessRequest - pInterface->tunerXM_XM_UPC_Get() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerXM_UPC::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_ITunerXMListener>(this);
      DIA_TR_ERR("dia_SrvHandler_TunerXM_UPC ---  SEND TO XM TUNER SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_TunerXM_UPC::vOnTunerXM_XM_UPC_Get ( tU8* base, tU8* overlay )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_UPC::vOnTunerXM_XM_UPC_Get");

//   if( ... ) {   // No way to check correctness
   (void) unsetSysAdapterListener<dia_ITunerXMListener>(this);
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   tU8 answPos = 0x00;
   for( ; answPos<0x06; answPos++){
      (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + answPos), (tU8) base[answPos]);
   }
   for( ; answPos<0x0C; answPos++){
      (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + answPos), (tU8) overlay[answPos-6]);
   }

   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_TunerXM_UPC::vOnTunerXM_XM_UPC_Get SUCCESSFUL");
}


