/*
 * dia_SrvHandler_TunerXM_AntennaStatus.cpp
 *
 *  Created on: 30.10.2012
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 61 45

#include "dia_SrvHandler_TunerXM_AntennaStatus.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif
#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerXM_AntennaStatus::dia_SrvHandler_TunerXM_AntennaStatus ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerXM_AntennaStatus",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_SXM_TUNER_ANTENNA_STATUS /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_AntennaStatus::dia_SrvHandler_TunerXM_AntennaStatus(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerXM_AntennaStatus::~dia_SrvHandler_TunerXM_AntennaStatus ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerXMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerXM_AntennaStatus::~dia_SrvHandler_TunerXM_AntennaStatus !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerXM_AntennaStatus::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_AntennaStatus::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerXM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerXM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerXM_AntennaStatus::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerXM_AntennaStatus::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerXMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START){
            DIA_TR_INF("dia_SrvHandler_TunerXM_AntennaStatus::vProcessRequest - MsgLength OK -> Send here!");
         } else {
            DIA_TR_ERR("dia_SrvHandler_TunerXM_AntennaStatus::vProcessRequest - MsgLength FAILED - different than expected!");
         }

         if ( pInterface->tunerXM_1_Antenna1Status_Get() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerXM_AntennaStatus::vProcessRequest - pInterface->tunerXM_Antenna1Status_Get() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerXM_AntennaStatus::vProcessRequest - pInterface->tunerXM_Antenna1Status_Get() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerXM_AntennaStatus::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerXMListener>(this);
      DIA_TR_ERR(" ---  SEND TO XM TUNER SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerXM_AntennaStatus::vOnTunerXM_1_Antenna1Status_Get ( tU8 status )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_AntennaStatus::vOnTunerXM_1_Antenna1Status_Get");

   (tVoid) unsetSysAdapterListener<dia_ITunerXMListener>(this);

   if (status<=DIA_EN_TUNERXM_ANTENNASTATUS_COUNT )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      tU8 cddStatus = DIA_EN_TUNERXM_ANTENNASTATUS_UNKNOWN;
      switch(status){
         case DIA_EN_TUNERXM_ANTENNASTATUS_UNKNOWN:
            cddStatus = 0xFF ;
            break;
         case DIA_EN_TUNERXM_ANTENNASTATUS_OK:
            cddStatus = 0x00 ;
            break;
         case DIA_EN_TUNERXM_ANTENNASTATUS_OPEN:
            cddStatus = 0x01 ;
            break;
         case DIA_EN_TUNERXM_ANTENNASTATUS_SHORT_GROUND:
            cddStatus = 0x05 ;
            break;
         case DIA_EN_TUNERXM_ANTENNASTATUS_NOT_SUPPORTED:
            cddStatus = 0x80 ;
            break;
         default:
            DIA_TR_ERR("dia_SrvHandler_TunerXM_AntennaStatus::vOnTunerXM_1_Antenna1Status_Get UNKNOWN ANTENNA STATUS.");
            break;
      }

      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) cddStatus));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerXM_AntennaStatus::vOnTunerXM_1_Antenna1Status_Get SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_TunerXM_AntennaStatus::vOnTunerXM_1_Antenna1Status_Get FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

}
