/*
 * dia_SrvHandler_TunerDRM_AntennaServiceID.cpp
 *
 *  Created on: 21.09.2015
 *      Author: nce5kor
 *------------------------------------------------------------------------------------------
 * Date         Author         Modification
 * 10.02.16	    bsu9kor		   Added code to handle RELUPREG message(SUZUKI-27972)
 *
 *--------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "../../../depricated/dia_common_core.h"
#endif

#include "dia_SrvHandler_TunerDRM_AntennaServiceID.h"


#define DATA_START 3
#define DATA_LENGTH 4
#define SID_MAX 0xFFFFFFFF

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerDRM_AntennaServiceID::dia_SrvHandler_TunerDRM_AntennaServiceID ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerDRM_AntennaServiceID",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_TUNER_DRM_SERVICE_ID /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDRM_AntennaServiceID::dia_SrvHandler_TunerDRM_AntennaServiceID(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerDRM_AntennaServiceID::~dia_SrvHandler_TunerDRM_AntennaServiceID ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerDRM_AntennaServiceID::~dia_SrvHandler_TunerDRM_AntennaServiceID !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerDRM_AntennaServiceID::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDRM_AntennaServiceID::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerAMFM_attachNotification(DIA_EN_TUNERAMFM_NOTIFICATION_FREQUENCY) == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vProcessRequest - pInterface->tunerAMFM_attachNotification() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vProcessRequest - pInterface->tunerAMFM_attachNotification() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      DIA_TR_ERR("dia_SrvHandler_TunerDRM_AntennaServiceID ---  SEND TO SAFEATURE TUNER DAB FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID ( tU32 serviceID ){
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID");

   DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID (1) detachNotification");
   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if (querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS)
   {
       DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID - querySysAdapterInterface OK.");
	   if (pInterface)
	   {
		   DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID - pInterface OK.");
			if (pInterface->tunerAMFM_detachNotification(DIA_EN_TUNERAMFM_NOTIFICATION_FREQUENCY) == DIA_SUCCESS)
			{
			   DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID - detachNotification() SUCCESS.");
			}
			else
			{
			   DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID - detachNotification() FAILED.");
			}
	    }
    }
    DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID (2) Send Result To Tester.");
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
     if(serviceID != SID_MAX )
     {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, U32_BYTE1(serviceID));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, U32_BYTE2(serviceID));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 2, U32_BYTE3(serviceID));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 3, U32_BYTE4(serviceID));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID SUCCESSFUL");
}
     else
     {
       	DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaServiceID::vOnTunerDRMGetServiceID FAIL");
       	// Sending back the Negative answer
       	vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);

     }
}
