/*
 * dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency.cpp
 *
 *  Created on: 21.09.2015
 *      Author: nce5kor
 *------------------------------------------------------------------------------------------
 * Date         Author         Modification
 * 10.02.16	    bsu9kor		   Added code to handle RELUPREG message(SUZUKI-27972)
 *
 *--------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "../../../depricated/dia_common_core.h"
#endif

#include "dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency.h"


#define DATA_START 3
#define DATA_LENGTH 4
#define FREQ_MAX 0xFFFFFFFF

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_TUNER_DRM_ENSEMBLE_FREQUENCY /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::~dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::~dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerAMFM_attachNotification(DIA_EN_TUNERAMFM_NOTIFICATION_FREQUENCY) == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vProcessRequest - pInterface->tunerAMFM_attachNotification() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vProcessRequest - pInterface->tunerAMFM_attachNotification() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      DIA_TR_ERR("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency ---  SEND TO SAFEATURE TUNER DRM FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency ( tU32 frequency ){
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency");

   DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency (1) detachNotification");
   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if (querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS)
   {
       DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency - querySysAdapterInterface OK.");
	   if (pInterface)
	   {
		   DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency - pInterface OK.");
			if (pInterface->tunerAMFM_detachNotification(DIA_EN_TUNERAMFM_NOTIFICATION_FREQUENCY) == DIA_SUCCESS)
			{
			   DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency - detachNotification() SUCCESS.");
			}
			else
			{
			   DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency - detachNotification() FAILED.");
			}
	    }
    }
    DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency (2) Send Result To Tester.");
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
    if (frequency != FREQ_MAX)
    {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, U32_BYTE1(frequency));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, U32_BYTE2(frequency));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 2, U32_BYTE3(frequency));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 3, U32_BYTE4(frequency));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency SUCCESSFUL");
    }
    else
    {
    	DIA_TR_INF("dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency::vOnTunerDRMGetFrequency FAIL");
    	// Sending back the Negative answer
    	vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);

    }
}

