/*
 * dia_SrvHandler_TunerAMFM_SelectActiveTuner.cpp
 *
 *  Created on: 11.10.2012
 *      Author: shw2abt
 */

// TTFis:\> DIA_REQ UDS 04 22 61 00

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SrvHandler_TunerAMFM_SelectActiveTuner.h"


#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_SelectActiveTuner::dia_SrvHandler_TunerAMFM_SelectActiveTuner ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerAMFM_SelectActiveTuner",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_TUNER_AMFM_SELECT_ACTIVE_TUNER /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_SelectActiveTuner::dia_SrvHandler_TunerAMFM_SelectActiveTuner(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_SelectActiveTuner::~dia_SrvHandler_TunerAMFM_SelectActiveTuner ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerAMFM_SelectActiveTuner::~dia_SrvHandler_TunerAMFM_SelectActiveTuner !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_TunerAMFM_SelectActiveTuner::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerMaster* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerMaster>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vProcessRequest - pInterface OK.");
         (void) setSysAdapterListener<dia_ITunerMasterListener>(this);

         if ( pInterface->tunerAMFM_ActiveTuner_Get() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vProcessRequest - tunerAMFM_ActiveTuner_Get SUCCESS.");
            errorDetected = FALSE;
         }
      }
   } else {
      DIA_TR_ERR("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
      DIA_TR_ERR("dia_SrvHandler_TunerAMFM_SelectActiveTuner --- SEND TO TUNER AMFM SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_TunerAMFM_SelectActiveTuner::vOnTunerAMFMActiveTuner_Get ( dia_eTuner activeTuner )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vOnTunerAMFMselectActiveTuner");

   (void) unsetSysAdapterListener<dia_ITunerMasterListener>(this);

   if(activeTuner!=DIA_EN_TUNERMASTER_UNKNOWN)
   {
      oDiagMsgBuffer().vSetPosResp();

      DIA_TR_INF("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vOnTunerAMFMselectActiveTuner - activeTuner: %d", activeTuner);
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
      switch(activeTuner){
         case DIA_EN_TUNERMASTER_1:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x00));
            break;
         case DIA_EN_TUNERMASTER_2:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x01));
            break;
         case DIA_EN_TUNERMASTER_3:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x02));
            break;
         case DIA_EN_TUNERMASTER_4:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x03));
            break;
         default:
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vOnTunerAMFMselectActiveTuner: DIA_EN_TUNERMASTER_XXX");
            break;
      }

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vOnTunerAMFMselectActiveTuner SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_SelectActiveTuner::vOnTunerAMFMselectActiveTuner FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
