/*
 * dia_SrvHandler_TunerAMFM_Fieldstrength.cpp
 *
 *  Created on: 10.10.2012
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 61 03

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SrvHandler_TunerAMFM_Fieldstrength.h"


#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_Fieldstrength::dia_SrvHandler_TunerAMFM_Fieldstrength ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerAMFM_Fieldstrength",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) 0x6103 /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Fieldstrength::dia_SrvHandler_TunerAMFM_Fieldstrength(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_Fieldstrength::~dia_SrvHandler_TunerAMFM_Fieldstrength ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerAMFM_Fieldstrength::~dia_SrvHandler_TunerAMFM_Fieldstrength !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_Fieldstrength::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Fieldstrength::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Fieldstrength::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerAMFM_Fieldstrength::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Fieldstrength::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerAMFM_TunerFieldStrength_Get() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Fieldstrength::vProcessRequest - pInterface->requestTrackNumber() OK.");
            errorDetected = FALSE;
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Fieldstrength::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      DIA_TR_ERR(" ---  SEND TO TUNER AMFM FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_Fieldstrength::vOnTunerAMFMFieldStrength_Get ( tU8 strength )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Fieldstrength::vOnTunerAMFMFieldStrength_Get");

   DIA_TR_INF("dia_SrvHandler_TunerAMFM_Fieldstrength::vOnTunerAMFMFieldStrength_Get - received strength: %d", strength);

   (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
   (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) strength));

   vResReadyAndQuit();
}
