/*
 * dia_SrvHandler_TunerAMFM_FMRDSProgramInformation.cpp
 *
 *  Created on: 18.10.2012
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 61 04

#include "dia_SrvHandler_TunerAMFM_FMRDSProgramInformation.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::dia_SrvHandler_TunerAMFM_FMRDSProgramInformation ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) 0x6104 /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::dia_SrvHandler_TunerAMFM_FMRDSProgramInformation(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::~dia_SrvHandler_TunerAMFM_FMRDSProgramInformation ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::~dia_SrvHandler_TunerAMFM_FMRDSProgramInformation !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerAMFM_TunerFMRDSProgramInformation_Get() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vProcessRequest - pInterface->tunerAMFM_AntennaStatus_Get() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vProcessRequest - pInterface->tunerAMFM_AntennaStatus_Get() FAILED.");
         }
      }
   } else {
      DIA_TR_ERR("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      DIA_TR_ERR(" ---  SEND TO TUNER MASTER SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInformation_Get ( tU16 PICode ){
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInformation_Get");

   DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInfo_Get (1) tunerAMFM_detachNotification");
   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if (querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS)
   {
//      DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInfo_Get -querySysAdapterInterface OK.");
      if (pInterface)
      {
//         DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInfo_Get -pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);

         if (pInterface->tunerAMFM_detachNotification(DIA_EN_TUNERAMFM_NOTIFICATION_RDSPROGRAMINFORMATION) == DIA_SUCCESS)
         {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInfo_Get - detachNotification() SUCCESS.");
         }
         else
         {
            DIA_TR_ERR("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInfo_Get - detachNotification() FAILED.");
         }
      }
   }

   (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);

   DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInfo_Get (2) Send Result To Tester.");
   if( PICode <= 0x0F0F )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      tU8 pi_small_b1  = U16_BYTE1(PICode);
      tU8 pi_small_b2  = U16_BYTE2(PICode);
      tU8 piCode_small = (tU8) ((pi_small_b1 << 4) + pi_small_b2);
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, piCode_small);

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInfo_Get SUCCESSFUL");
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_TunerAMFM_FMRDSProgramInformation::vOnTunerFMRDSProgramInfo_Get FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }


}
