/*
 * dia_SrvHandler_TunerAMFM_Band.cpp
 *
 *  Created on: 17.10.2012
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 61 02

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SrvHandler_TunerAMFM_Band.h"


#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_Band::dia_SrvHandler_TunerAMFM_Band ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerAMFM_Band",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) 0x6102 /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Band::dia_SrvHandler_TunerAMFM_Band(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_Band::~dia_SrvHandler_TunerAMFM_Band ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerAMFM_Band::~dia_SrvHandler_TunerAMFM_Band !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_Band::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Band::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerAMFM_TunerBand_Get() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vProcessRequest - pInterface->tunerAMFM_TunerBand_Get() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vProcessRequest - pInterface->tunerAMFM_TunerBand_Get() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      DIA_TR_ERR(" ---  SEND TO TUNER MASTER SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get ( dia_eBandAMFM activeBand )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get");

   DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get (1) tunerAMFM_detachNotification");
   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if (querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS) {
//      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get -querySysAdapterInterface OK.");
      if (pInterface) {
//         DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get -pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);

         if (pInterface->tunerAMFM_detachNotification(DIA_EN_TUNERAMFM_NOTIFICATION_BAND) == DIA_SUCCESS) {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get -detachNot. SUCCESS.");
         } else {
            DIA_TR_ERR("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get -detachNot. FAILED.");
         }
      }
   }

   (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);

   DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get (2) Send Result To Tester.");
   if(activeBand != DIA_EN_AMFMTUNER_BAND_UNKNOWN && activeBand < DIA_EN_AMFMTUNER_BAND_COUNT )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      if(activeBand == DIA_EN_AMFMTUNER_BAND_AM) {
         (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x02));
      } else if (activeBand == DIA_EN_AMFMTUNER_BAND_FM){
         (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x01));
      } else {
         DIA_TR_ERR("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get UNKNOWN BAND.");
      }

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get SUCCESSFUL");
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_TunerAMFM_Band::vOnTunerAMFMBand_Get FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
