/*
 * dia_SrvHandler_TunerAMFM_Antenna1Status.cpp
 *
 *  Created on: 07.02.2014
 *      Author: kth4kor
 */
// TTFis:\> DIA_REQ UDS 04 22 61 07

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SrvHandler_TunerAMFM_Antenna2Status.h"


#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_Antenna2Status::dia_SrvHandler_TunerAMFM_Antenna2Status ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerAMFM_Antenna2Status",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_2_STATUS /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Antenna2Status::dia_SrvHandler_TunerAMFM_Antenna2Status(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_Antenna2Status::~dia_SrvHandler_TunerAMFM_Antenna2Status ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerAMFM_Antenna2Status::~dia_SrvHandler_TunerAMFM_Antenna2Status !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_Antenna2Status::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Antenna2Status::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerMaster* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerMaster>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Antenna2status::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerAMFM_Antenna2status::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerMasterListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Antenna2Status::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerAMFM_Antenna2Status_Get() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Antenna2Status::vProcessRequest - pInterface->tunerAMFM_Antenna2Status_Get() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Antenna2Status::vProcessRequest - pInterface->tunerAMFM_Antenna2Status_Get() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Antenna2Status::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
      DIA_TR_ERR(" ---  SEND TO TUNER MASTER SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_Antenna2Status::vOnTunerAMFMAntenna2Status_Get ( dia_eAntennaStatus antennaStatus )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Antenna2Status::vOnTunerAMFMAntenna2Status_Get");

   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);

   if (/*antennaStatus != DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN &&*/ antennaStatus < DIA_EN_TUNERMASTER_ANTENNASTATUS_COUNT )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      switch(antennaStatus)
      {
         case DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN:
            (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0xFF));
            DIA_TR_INF("vOnTunerAMFMAntennaStatus_Get => DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN");
            break;
         case DIA_EN_TUNERMASTER_ANTENNASTATUS_OK:
            (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x00));
            DIA_TR_INF("vOnTunerAMFMAntennaStatus_Get => DIA_EN_TUNERMASTER_ANTENNASTATUS_OK");
            break;
         case DIA_EN_TUNERMASTER_ANTENNASTATUS_OPEN:
            (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x01));
            DIA_TR_INF("vOnTunerAMFMAntennaStatus_Get => DIA_EN_TUNERMASTER_ANTENNASTATUS_OPEN");
            break;
         case DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT:
            (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x02));
            DIA_TR_INF("vOnTunerAMFMAntennaStatus_Get => DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT");
            break;
         case DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_ACROSS:
            (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x03));
            DIA_TR_INF("vOnTunerAMFMAntennaStatus_Get => DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_ACROSS");
            break;
         case DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_BATTERY:
            (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x04));
            DIA_TR_INF("vOnTunerAMFMAntennaStatus_Get => DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_BATTERY");
            break;
         case DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_GROUND:
            (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x05));
            DIA_TR_INF("vOnTunerAMFMAntennaStatus_Get => DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_GROUND");
            break;
         default:
            DIA_TR_ERR("vOnTunerAMFMAntenna2Status_Get - WRONG ANTENNA STATUS!!!");
            break;
      }

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Antenna2Status::vOnTunerAMFMAntenna2Status_Get SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Antenna2Status::vOnTunerAMFMAntenna2Status_Get FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void dia_SrvHandler_TunerAMFM_Antenna2Status::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_TunerAMFM_Antenna2Status::vOnTimeout(void)");
   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();
}

