/*
 * dia_SrvHandler_SystemHmiOnGet.cpp
 *
 *  Created on: 29.11.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_IOCTRL_SYSTEM_HMI_ON__
#include "dia_IOCtrlSystemHmiOn.h"
#endif

#include "dia_SrvHandler_SystemHmiOnGet.h"

static const tU16 DATA_START  = 3;
static const tU16 DATA_LENGTH = 1;

//-----------------------------------------------------------------------------

dia_SrvHandler_SystemHmiOnGet::dia_SrvHandler_SystemHmiOnGet ( tVoid )
   : dia_ServiceHandlerUDS (
         "dia_SrvHandler_SystemHmiOnGet",
         DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
         DIA_C_U16_DID_RBCM_SYSTEM_HMI_ON
         )
{
   dia_tclFnctTrace trc("dia_SrvHandler_SystemHmiOnGet::dia_SrvHandler_SystemHmiOnGet(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_SystemHmiOnGet::~dia_SrvHandler_SystemHmiOnGet ( tVoid )
{
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_SystemHmiOnGet::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_SystemHmiOnGet::vProcessRequest");

   // Sending back the positive answer
   	   tBool bHMIState = false;
      dia_ISpm* pInterface = 0;
      dia_eSpmHmiState mHMIState = DIA_EN_SPM_HMI_STATE_UNKNOWN;
      tDiaResult retCode =  querySysAdapterInterface<dia_ISpm>(&pInterface);

      if ( (retCode == DIA_SUCCESS) && pInterface )
      {
           (void) pInterface->getHmiState(mHMIState);
           DIA_TR_INF("HMI State    = 0x%08x",mHMIState);
		   oDiagMsgBuffer().vSetPosResp();
		   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
		   if(mHMIState == DIA_EN_SPM_HMI_STATE_SHOW_HMI){
			   bHMIState = true; // display on
		   }
		   (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START, bHMIState);
		   vResReadyAndQuit();
        }
      else
      {
    	  // error detected
    	  vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      }

}

