/*
 * dia_SrvHandler_MaximumRamConsumption.h
 *
 *  Created on: 19.02.2018
 *      Author: hpe2hi
 */

// todo hpe2hi: why is spm missing in all names.
//TTFis: DIA_REQ UDS 04 22 b1 15
#ifndef DIA_SRVHANDLER_STARTUP_TIME_STATISTIC_H_
#define DIA_SRVHANDLER_STARTUP_TIME_STATISTIC_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

class dia_SrvHandler_StartupTimeStatistic
   : public dia_ServiceHandlerUDS,
     public dia_ISpmListenerImpl
{
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_StartupTimeStatistic);


public:
   //! class constructor
      dia_SrvHandler_StartupTimeStatistic ( void );

   /**
     * \brief    	handle the received request
     *
     *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *				The SystemAdapter returns the statistics for startup times
     *
     * \param[in]	const std::vector<void*>&      not used here
     */
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief    	status for the requested statistics for startup time
     *
     *				Function receives the message via its parameter and send it to the tester.
     *				It verifies the SA answer and send the startup time statistics to the tester.
     *
     *
     */

   virtual void vOnGetStartupTimeStatistics (dia_tSpmStatisticData statistics );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_StartupTimeStatistic(void);

};


#endif /* DIA_SRVHANDLER_STARTUP_TIME_STATISTIC_H_ */
