/*
 * dia_SrvHandler_SDCard1SlotState.h
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 */

#ifndef dia_SrvHandler_SDCARD1SLOTSTATE_H_
#define dia_SrvHandler_SDCARD1SLOTSTATE_H_

#ifndef __INCLUDED_DIA_INTERFACE_DEVICE_MANAGER_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

class dia_SrvHandler_SDCard1SlotState
   : public dia_ServiceHandlerUDS,
     public dia_IDeviceMGRListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_SDCard1SlotState);


public:
   //! class constructor
   dia_SrvHandler_SDCard1SlotState ( void );

   /**
     * \brief     handle the received request
     *
     *            Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *            The SystemAdapter returns the current of the GNSS antenna.
     *
     * \param[in] void*     -
     * \param[in] void*     -
     */
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief     status for the requested the current of the GNSS antenna
     *
     *            Function receives the message via its parameter and send it to the tester.
     *            It verifies the SA answer and send the expected value to the tester.
     *
     * \param[in] midw_ext_fi_tclString btDeviceAddr  BT Device Name String
     * \param[in] tU32 btDeviceAddr_size length of btDeviceAddr
     */
   virtual void vOnSDStates ( const std::vector<dia_tSdcStates>& SdcStatesList );


protected:
   //! class destructor
   virtual ~dia_SrvHandler_SDCard1SlotState(void);

};


#endif /* dia_SrvHandler_SDCARD1SLOTSTATE_H_ */
