/*
 * dia_SrvHandler_SDCard1MediaInfo.cpp
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 */
// TTFis: DIA_REQ UDS 04 22 63 11

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SrvHandler_SDCard1MediaInfo.h"

#ifndef __INCLUDED_DIA_INTERFACE_DEVICE_MANAGER_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 15


//-----------------------------------------------------------------------------

dia_SrvHandler_SDCard1MediaInfo::dia_SrvHandler_SDCard1MediaInfo( void )
    : dia_ServiceHandlerUDS( "dia_SrvHandler_SDCard1MediaInfo", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_SD_CARD_1_MEDIA_INFO /*DID*/ )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_SDCard1MediaInfo::dia_SrvHandler_SDCard1MediaInfo(void)" );
}

//-----------------------------------------------------------------------------

dia_SrvHandler_SDCard1MediaInfo::~dia_SrvHandler_SDCard1MediaInfo( void )
{
    _BP_TRY_BEGIN
    {
       (void)unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR( "EXCEPTION CAUGHT: dia_SrvHandler_SDCard1MediaInfo::~dia_SrvHandler_SDCard1MediaInfo !!!" );
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_SDCard1MediaInfo::vProcessRequest( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_SDCard1MediaInfo::vProcessRequest" );

   tBool errorDetected = TRUE;
   dia_IDeviceMGR* pDeviceMGR = 0;
   if( querySysAdapterInterface<dia_IDeviceMGR>(&pDeviceMGR) == DIA_SUCCESS )
   {
      if( pDeviceMGR )
      {
         (void) setSysAdapterListener<dia_IDeviceMGRListener>(this);
         if( pDeviceMGR->getSDCardDiagValues() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if( errorDetected )
   {
      (void)unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
      DIA_TR_ERR( " ---  SEND TO Media Manager Component failed!!!!" );
      oDiagMsgBuffer().vSetNegResp( DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT );
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_SDCard1MediaInfo::vOnSDCIDRegister( const std::vector<dia_tSdcCIDs>& SdcCidList )
{
   tBool bRetCorrect = FALSE;

   dia_tclFnctTrace trc( "dia_SrvHandler_SDCard1MediaInfo::vOnSDCIDRegister" );

   (void) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);

   std::vector<dia_tSdcCIDs>::const_iterator it = SdcCidList.begin();

   if( !SdcCidList.empty() )
   {
      for( ; it != SdcCidList.end(); ++it )
      {
         dia_tSdcCIDs   oSdcCid = (*it);
         if(  oSdcCid.SlotNo == 1 )          // Check if the slot number is 1
         {
            bRetCorrect = TRUE;
            oDiagMsgBuffer().vSetPosResp();
            oDiagMsgBuffer().vSetDataLength( DATA_START+ DATA_LENGTH );
            DIA_TR_INF( "Status10 = %d",oSdcCid.CID[10] );
            //Manufacturer ID (MID)
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 0, oSdcCid.CID[ 0] );
            //OEM/Application ID (OID)
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 1, oSdcCid.CID[ 1] );
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 2, oSdcCid.CID[ 2] );
            //Product Name (PNM)
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 3, oSdcCid.CID[ 3] );
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 4, oSdcCid.CID[ 4] );
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 5, oSdcCid.CID[ 5] );
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 6, oSdcCid.CID[ 6] );
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 7, oSdcCid.CID[ 7] );
            //Product Revision** (PRV)
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 8, oSdcCid.CID[ 8] );
            //Serial Number (PSN)
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+ 9, oSdcCid.CID[ 9] );
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+10, oSdcCid.CID[10] );
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+11, oSdcCid.CID[11] );
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+12, oSdcCid.CID[12] );
            //Manufacture Date Code (MDT) Year
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+13, (tU8)( (oSdcCid.CID[13]<<4)| (oSdcCid.CID[14]>>4) ) );
            //Manufacture Date Code (MDT) Month
            (void) oDiagMsgBuffer().vSetDataU8( DATA_START+14, (oSdcCid.CID[14] & 0x0F) );
         }
      }
   }

   if( bRetCorrect )
   {
       vResReadyAndQuit();
       DIA_TR_INF( "dia_SrvHandler_SDCard1MediaInfo::vOnSDCIDRegister SUCCESSFUL" );
   }
   else
   {
      DIA_TR_INF( "dia_SrvHandler_SDCard1MediaInfo::vOnSDCIDRegister FAIL" );
      // Sending back the Negative answer
      vSendNegativeResponse( DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT );
   }
}
