/*
 * dia_SrvHandler_ReadWifiMode.h
 *
 *  Created on: 14.02.2019
 *      Author: kaa1hi
 */
// TTFis:\> DIA_REQ UDS 03 22 64 30

#ifndef __INCLUDED_DIA_SRVHANDLER_READ_WIFI_MODE__
#define __INCLUDED_DIA_SRVHANDLER_READ_WIFI_MODE__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_SETUPS_LISTENER__
#include "common/interfaces/dia_IWifiSetupsListener.h"
#endif

class dia_SrvHandler_ReadWifiMode
   : public dia_ServiceHandlerUDS,
     public dia_IWifiSetupsListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadWifiMode);

public:
   //! class constructor
   dia_SrvHandler_ReadWifiMode ( void );

   //! class destructor
   virtual ~dia_SrvHandler_ReadWifiMode ( );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IWifiSetupsListenerImpl methods
   //
   //-------------------------------------------------------------------------

   //! List of currently active wifi setups (wlan devices).
   virtual void OnActiveSetups ( const std::vector<dia_stWifiSetup>& /*setupList*/ );

private:
   const std::map<dia_enWifiMode, tU8> mMapWifiModeToByte =
   {
      { DIA_ENUM_WIFI_MODE_OFF_STA, 0 },
      { DIA_ENUM_WIFI_MODE_STA,     1 },
      { DIA_ENUM_WIFI_MODE_AP,      2 }
   };

   static const tU8 DATA_START;
};

#endif /*__INCLUDED_DIA_SRVHANDLER_READ_WIFI_MODE__ */
