/*
 * dia_SrvHandler_ReadWifiMode.cpp
 *
 *  Created on: 14.02.2019
 *      Author: kaa1hi
 */
// TTFis:\> DIA_REQ UDS 03 22 64 30

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_WIFI_MODE__
#include "dia_SrvHandler_ReadWifiMode.h"
#endif

const tU8 dia_SrvHandler_ReadWifiMode::DATA_START = 3;

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadWifiMode::dia_SrvHandler_ReadWifiMode ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_ReadWifiMode", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_IOCTRL_WIFI_MODE)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadWifiMode::dia_SrvHandler_ReadWifiMode(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadWifiMode::~dia_SrvHandler_ReadWifiMode ()
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IWifiSetupsListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_ReadWifiMode::~dia_SrvHandler_ReadWifiMode !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ReadWifiMode::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadWifiMode::vProcessRequest");

   bool errorDetected = true;

   dia_IWifiSetups* pInterface = nullptr;
   if (( querySysAdapterInterface<dia_IWifiSetups>(&pInterface) == DIA_SUCCESS ) && pInterface )
   {
      (void) setSysAdapterListener<dia_IWifiSetupsListener>(this);
      if ( pInterface->GetActiveSetups() == DIA_SUCCESS )
      {
         errorDetected = false;
      }
      else
      {
         DIA_TR_INF("dia_SrvHandler_ReadWifiMode::vProcessRequest - getSystemInfo() failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_ReadWifiMode::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IWifiSetupsListener>(this);
      DIA_TR_ERR("dia_SrvHandler_ReadWifiMode::vProcessRequest ---  SEND TO WIFI SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

void
dia_SrvHandler_ReadWifiMode::OnActiveSetups( const std::vector<dia_stWifiSetup>& setupList )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadWifiMode:OnActiveSetups( const std::vector<dia_stWifiSetup>& setupList )");

   (void) unsetSysAdapterListener<dia_IWifiSetupsListener>(this);

   dia_enWifiMode wifiMode = DIA_ENUM_WIFI_MODE_UNKNOWN;

   if (setupList.empty())
   {
      DIA_TR_ERR("### dia_SrvHandler_ReadWifiMode::OnActiveSetups setupList is empty.");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   std::vector<dia_stWifiSetup>::const_iterator it = setupList.begin();
   for ( ; (it != setupList.end()) && (DIA_ENUM_WIFI_MODE_UNKNOWN==wifiMode); ++it)
   {
      switch (it->mMode)
      {
         case DIA_ENUM_WIFI_MODE_AP:
         {
            if (it->mPoweredOn)
            {
               DIA_TR_INF("dia_SrvHandler_ReadWifiMode::OnActiveSetups DIA_ENUM_WIFI_MODE_AP mPoweredOn true.");
               wifiMode = DIA_ENUM_WIFI_MODE_AP;
            }
            else
            {
               DIA_TR_INF("dia_SrvHandler_ReadWifiMode::OnActiveSetups DIA_ENUM_WIFI_MODE_AP mPoweredOn false");
            }
            break;
         }

         case DIA_ENUM_WIFI_MODE_STA:
         {
            if (it->mPoweredOn)
            {
               DIA_TR_INF("dia_SrvHandler_ReadWifiMode::OnActiveSetups DIA_EN_WIFI_MODE_STA mPoweredOn true.");
               wifiMode = DIA_ENUM_WIFI_MODE_STA;
            }
            else
            {
               DIA_TR_INF("dia_SrvHandler_ReadWifiMode::OnActiveSetups DIA_EN_WIFI_MODE_STA mPoweredOn false");
            }
            break;
         }

         default:
         {
            DIA_TR_ERR("dia_SrvHandler_ReadWifiMode::OnActiveSetups Unexpected WIFI Mode = %d.", it->mMode);
            break;
         }
      }
   }

   if (DIA_ENUM_WIFI_MODE_UNKNOWN==wifiMode)
   {
      DIA_TR_WRN("dia_SrvHandler_ReadWifiMode::OnActiveSetups all modes off.");
      wifiMode = DIA_ENUM_WIFI_MODE_OFF_STA;
   }

   std::map<dia_enWifiMode, tU8>::const_iterator itt = mMapWifiModeToByte.find(wifiMode);
   if ( mMapWifiModeToByte.end() != itt )
   {
      DIA_TR_INF("dia_SrvHandler_ReadWifiMode::OnActiveSetups WifiMode 0x%02X converted to 0x%02X.", wifiMode, itt->second);
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + 1);
      (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START + 0), itt->second);
      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_ERR("### dia_SrvHandler_ReadWifiMode::OnActiveSetups Invalid wifi mode 0x%02X.", wifiMode);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

