/*
 * dia_SrvHandler_ReadTotalWrittenBlockCount.h
 *
 */

#ifndef dia_SrvHandler_ReadTotalWrittenBlockCount_H_
#define dia_SrvHandler_ReadTotalWrittenBlockCount_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

class dia_SrvHandler_ReadTotalWrittenBlockCount
   : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadTotalWrittenBlockCount);

public:
   //! class constructor
   dia_SrvHandler_ReadTotalWrittenBlockCount();

   //! class destructor
   virtual ~dia_SrvHandler_ReadTotalWrittenBlockCount();

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/);

private:
   static const size_t dataSize = 512;
   std::vector<tU8> getDeviceNode(std::string const&) const;
   std::string getFilename() const;
   std::string getFilePath(std::string const&) const;
   std::vector<tU8> getWrittenBytes(std::string const&) const;
   std::vector<tU8> getEmmcNode() const;
};

#endif /* dia_SrvHandler_ReadTotalWrittenBlockCount_H_ */
