/*
 * dia_SrvHandler_ReadLastDiagnosisError.cpp
 *
 *  Created on: Oct 6, 2017
 *      Author: maj9kor
 */

// TTFis: DIA_REQ UDS 04 22 D0 01

#include "dia_SrvHandler_ReadLastDiagnosisError.h"

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#define DATA_START 3
#define ERRORINFO_SIZE 0
using namespace dia;
//-----------------------------------------------------------------------------

dia_SrvHandler_ReadLastDiagnosisError::dia_SrvHandler_ReadLastDiagnosisError ( tCString name, tU8 sid, tU8 did )
   : dia_ServiceHandlerUDS(name,sid,(tU8) did)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadLastDiagnosisError::dia_SrvHandler_ReadLastDiagnosisError(tCString,tU8,tU8)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadLastDiagnosisError::dia_SrvHandler_ReadLastDiagnosisError ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadLastDiagnosisError::dia_SrvHandler_ReadLastDiagnosisError(tCString,tU8,tU16)");
}
//-----------------------------------------------------------------------------
dia_SrvHandler_ReadLastDiagnosisError::dia_SrvHandler_ReadLastDiagnosisError ( tCString name, tU8 sid, tU8 did, tU32 /*mask*/ )
   : dia_ServiceHandlerUDS(name,sid,did)
{
    dia_tclFnctTrace oTrace("dia_SrvHandler_ReadLastDiagnosisError::dia_SrvHandler_ReadLastDiagnosisError(sid,did,mask)");
}
//-----------------------------------------------------------------------------

dia_SrvHandler_ReadLastDiagnosisError::~dia_SrvHandler_ReadLastDiagnosisError ( void )
{}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_ReadLastDiagnosisError::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadLastDiagnosisError::vOnProcessRequest");
   // received message
   for ( tU16 i = 0; i < oDiagMsgBuffer().u16GetDataLength(); i++){\
      DIA_TR_INF("dia_SrvHandler_ReadLastDiagnosisError::input-buffer[%d] 0x%02x", i, oDiagMsgBuffer().u8GetData(i) );
   }

   if ( vecArgs.size() )
   {
	 tU32 propID1 = (tU32) vecArgs[0]; // DIA_PROP_CM_CONFIG_LAST_DIAG_ERROR

	 std::vector<tU8> dataVec;
	 tDiaResult retCode = dia_getProperty(propID1,dataVec);

	 if (retCode == DIA_SUCCESS )
	 {
	   // Sending back the positive answer
	   oDiagMsgBuffer().vSetPosResp();
	   tU16 size = ERRORINFO_SIZE ;
	   while( dataVec[size] != '\0'){ size++ ; }
	   oDiagMsgBuffer().vSetDataLength((tU16) (DATA_START + size));
	   for (tU16 i = 0; i < size; i++)
	   {
	    (void) oDiagMsgBuffer().vSetDataU8((tU16)(DATA_START + i), dataVec[i]);
            DIA_TR_INF("dia_SrvHandler_ReadLastDiagnosisError::oDiagMsgBuffer[%u]=%c(%02x)", i, dataVec[i],dataVec[i] );
	   }
	   DIA_TR_INF("dia_SrvHandler_ReadLastDiagnosisError::ReadDataByIdentifier SUCCESSFUL");
	   vResReadyAndQuit();
      }
      else
      {
       DIA_TR_INF("dia_SrvHandler_ReadLastDiagnosisError::ReadDataByIdentifier FAIL <--------------");
       DIA_TR_INF("dia_SrvHandler_ReadLastDiagnosisError::ReadDataByIdentifier Unable to read Item.");
       // Sending back the Negative answer
       vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      }
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_ReadLastDiagnosisError::ReadDataByIdentifier FAIL <--------------");
      DIA_TR_INF("dia_SrvHandler_ReadLastDiagnosisError::ReadDataByIdentifier NO PARAMETER.");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
