/*!
 * \file       dia_SrvHandler_ReadEmmcJedecCidData.h
 *
 * \brief      CM Diag Servicehandler to read CID and CSD data for eMMC
 *
 * \component  Diagnostics
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef DIA_SRVHANDLER_READEMMCJEDECCIDREG_H_
#define DIA_SRVHANDLER_READEMMCJEDECCIDREG_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

/**
 * \brief ServiceHandler to read CID and CSD data
 * \details CM Diagnostic UDS based service to read eMMC extended CSD
 *          data for field-data-evaluation
 *          See CM Basevariant: 22 66 30 (CID)
 *          See CM Basevariant: 22 66 31 (CSD)
 * \ingroup    diaServicesCommon
 */
class dia_SrvHandler_ReadEmmcJedecCidReg
   : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadEmmcJedecCidReg);

public:
   //! class constructor
   dia_SrvHandler_ReadEmmcJedecCidReg();

   //! class destructor
   virtual ~dia_SrvHandler_ReadEmmcJedecCidReg ();

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/);
   //! provide lookup keys
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );
private:
   static const size_t registerSize = 32;
   std::string getFilename() const;
   std::string getFilePath(std::string) const;
};

#endif /* DIA_SRVHANDLER_READEMMCJEDECCIDREG_H_ */
