/**
 * \file    dia_SrvHandler_ReadDataByMemory.h
 *
 * \brief   This file contains the definition of the dia_SrvHandler_ReadDataByMemory class,
 *          that provides a generic service handler that can be used to process
 *          write requests for the ConfigManager.
 *
 * \author  shw2abt
 * \date    2012/05/04
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#ifndef dia_SrvHandler_ReadDataByMemory_H_
#define dia_SrvHandler_ReadDataByMemory_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

// TODO - Defines auslagern?
#define DIA_PROP_CCA_MSG_MAX_PAYLOAD 240	// Max. payload of a CCA Msg.

/**
 * \class   dia_SrvHandler_ReadDataByMemory
 *
 * \brief   Generic service handler to process Identification request
 *
 *          This class provides a generic service handler that can be used to process
 *          identification requests that need to write one or more properties into
 *          the ConfigManager module.
 *
 * \ingroup diaServicesCommon	// TODO - Woher kommt das? dia_ServiceHandlerUDS?
 */

class dia_SrvHandler_ReadDataByMemory
    : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadDataByMemory);

public:
   /**
    *
    * \brief      class constructor
    *
    * \return     none
    */
   dia_SrvHandler_ReadDataByMemory ( tVoid );

   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandler_ReadDataByMemory ( tVoid );

   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    *
    * \return     none
    */
   virtual tVoid vProcessRequest ( const std::vector<tArgsType>& vecArgs );
};

#endif /* dia_SrvHandler_ReadDataByMemory_H_ */
