/*!
 * \file       dia_SrvHandler_ReadAnonymousVIN.h
 *
 * \brief      Read Anonymous part of VIN, WMI(World Manufacturer Identifier) and VDS(Vehicle Descriptor Section) only
 *
 * \component  Diagnostics
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SRVHANDLER_READ_ANONYMOUSVIN_H__
#define __INCLUDED_DIA_SRVHANDLER_READ_ANONYMOUSVIN_H__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

/**
 * \class   dia_SrvHandler_ReadAnonymousVIN
 */

class dia_SrvHandler_ReadAnonymousVIN
    : public dia_ServiceHandlerUDS
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandler_ReadAnonymousVIN);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadAnonymousVIN);

public:

   //! class constructor
   dia_SrvHandler_ReadAnonymousVIN ( tCString name, tU8 sid, tU16 did );
   //! class destructor
   virtual ~dia_SrvHandler_ReadAnonymousVIN ( void );

   //! process the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );
};

#endif /* __INCLUDED_DIA_SRVHANDLER_READ_ANONYMOUSVIN_H__ */

