/*
 * dia_SrvHandler_ReadADR3AmpConfig.h
 *
 *  Created on: 09.03.2016
 *      Author: bma9kor
 */

// TTFis:\> DIA_REQ UDS 04 22 70 16 ADR3 Amplification Configuration

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef DIA_SRVHANDLER_READADR3AMPCONFIG_H_
#include "dia_SrvHandler_ReadADR3AmpConfig.h"
#endif

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadADR3AmpConfig::dia_SrvHandler_ReadADR3AmpConfig ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_ReadADR3AmpConfig",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_ADR3_AMPLIFIER_CONFIGURATION /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadADR3AmpConfig::dia_SrvHandler_ReadADR3AmpConfig(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadADR3AmpConfig::~dia_SrvHandler_ReadADR3AmpConfig ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_IADRListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_ReadADR3AmpConfig::~dia_SrvHandler_ReadADR3AmpConfig !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_ReadADR3AmpConfig::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadADR3AmpConfig::vProcessRequest");
   tDiaResult mErrorCode = DIA_SUCCESS;
   dia_IADR* pADR = OSAL_NULL;
   if ( querySysAdapterInterface<dia_IADR>(&pADR) == DIA_SUCCESS )
   {
	   if(pADR)
	   {
		   (tVoid) setSysAdapterListener<dia_IADRListener>(this);
		    std::vector<tU8> adrMessage;

	         for ( tU16 i=1; i<oDiagMsgBuffer().u16GetDataLength(); i++ )
	         {
	            adrMessage.push_back(oDiagMsgBuffer().u8GetData(i));
	         }

		   if ( pADR->sendADRContainerMessage(adrMessage) != DIA_SUCCESS )
		   {
			   mErrorCode = DIA_FAILED;
		   }
	   }
   }
   else
   {
	   mErrorCode = DIA_FAILED;
   }
   if ( mErrorCode )
   {
      (tVoid) unsetSysAdapterListener<dia_IADRListener>(this);
      DIA_TR_ERR(" ---  SEND TO ADR3 FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_ReadADR3AmpConfig::vOnADRContainerMessageResponse ( std::vector<tU8>& adrResponse )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadADR3AmpConfig::vOnADRContainerMessageResponse");

   (tVoid) unsetSysAdapterListener<dia_IADRListener>(this);
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength((tU16) adrResponse.size());
   for ( tU16 i=0; i < adrResponse.size(); i++ )
   {
      oDiagMsgBuffer().setDataU8(i, adrResponse[i]);
   }
   vResReadyAndQuit();
}
