/**
 * \file      dia_SrvHandler_ReadADCRefPlusActualVoltage.h
 *
 * \brief     {Reference + Actual/ Measured bytes => ADC Voltage write}
 *
 * \details   {Reference + Actual/ Measured bytes => ADC Voltage write}
 *
 * \author    bhs1hi
 * \date      Aug 07, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_ADC_REF_ACTUAL_VOLTAGE_READ__
#define __INCLUDED_DIA_ADC_REF_ACTUAL_VOLTAGE_READ__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

class dia_SrvHandler_ReadADCRefPlusActualVoltage
   : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadADCRefPlusActualVoltage);

public:
   //! class constructor
   dia_SrvHandler_ReadADCRefPlusActualVoltage ( void );
   //! process the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

protected:
	//! class destructor
	virtual ~dia_SrvHandler_ReadADCRefPlusActualVoltage(void);
};
#endif /* __INCLUDED_DIA_ADC_REF_ACTUAL_VOLTAGE_READ__ */
