/**
 * \file      dia_SrvHandler_ReadADCRefPlusActualVoltage.cpp
 *
 * \brief     {Reference + Actual/ Measured bytes => ADC Voltage write}
 *
 * \details   {Reference + Actual/ Measured bytes => ADC Voltage write}
 *
 * \author    bhs1hi
 * \date      Aug 07, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_ADC_REF_ACTUAL_VOLTAGE_READ__
#include "common/services/uds/production/dia_SrvHandler_ReadADCRefPlusActualVoltage.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#define DATA_START      3

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadADCRefPlusActualVoltage::dia_SrvHandler_ReadADCRefPlusActualVoltage ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandler_ReadADCRefPlusActualVoltage",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,DIA_C_U16_DID_CM_ADC_REF_PLUS_ACTUAL_VOLTAGE)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadADCRefPlusActualVoltage::dia_SrvHandler_ReadADCRefPlusActualVoltage");
}
//-----------------------------------------------------------------------------

dia_SrvHandler_ReadADCRefPlusActualVoltage::~dia_SrvHandler_ReadADCRefPlusActualVoltage ( void )
{
}
//-----------------------------------------------------------------------------

void
dia_SrvHandler_ReadADCRefPlusActualVoltage::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadADCRefPlusActualVoltage::vOnProcessRequest");

   tU8 u8data[4] = {0};
   (void) ::memset(u8data, 0, 4);

   tDiaResult retCode = dia_getProperty ( DIA_PROP_AID_ADC_REF_PLUS_ACTUAL_VOLTAGE, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_AID_ADC_REF_PLUS_ACTUAL_VOLTAGE)) );

   DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage::vProcessRequest u8data [0] = [%d]", u8data [0]);
   DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage::vProcessRequest u8data [1] = [%d]", u8data [1]);
   DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage::vProcessRequest u8data [2] = [%d]", u8data [2]);
   DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage::vProcessRequest u8data [3] = [%d]", u8data [3]);


   DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage::vProcessRequest u8data [0] = 0x%02x", u8data [0]);
   DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage::vProcessRequest u8data [1] = 0x%02x", u8data [1]);
   DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage::vProcessRequest u8data [2] = 0x%02x", u8data [2]);
   DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage::vProcessRequest u8data [3] = 0x%02x", u8data [3]);

   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage: FAILED (READ DATA FROM PERSISTENT MEMORY) !!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
   else
   {
      // Sending back the positive answer
      DIA_TR_INF("dia_SrvHandler_ReadADCRefPlusActualVoltage: SUCCEEDED");
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START+4);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START+0, (tU8)u8data [1]);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START+1, (tU8)u8data [0]);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START+2, (tU8)u8data [3]);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START+3, (tU8)u8data [2]);
      vResReadyAndQuit();
   }
}
