/*
 * dia_SrvHandler_RadioTypeApprovalModeRead.cpp
 *
 *  Created on: 25.02.2016
 *      Author: bsu9kor
 */
//TTFis:> DIA_REQ UDS 04 22 81 69
#ifndef  DIA_SRVHANDLER_RADIO_TYPE_APPROVAL_MODE_READ_H_
#include "common/services/uds/production/dia_SrvHandler_RadioTypeApprovalModeRead.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include "common/framework/application/dia_File.h"
#endif

static tCString FILEPATH = "/var/opt/bosch/dynamic/connectivity/bt_module/rta_enable";
#define DATA_LENGHTH 	((tU8)4)
#define DATA_START      3
#define ENABLED 		0x01
#define DISABLED		0x00

//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    dia_SrvHandler_RadioTypeApprovalModeRead (Class constructor)
*
* DESCRIPTION: Invokes the class with appropriate Class name, SID, DID
*
* PARAMETER:   void
*
* RETURNVALUE: NA
*
******************************************************************************/
dia_SrvHandler_RadioTypeApprovalModeRead::dia_SrvHandler_RadioTypeApprovalModeRead ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandler_RadioTypeApprovalModeRead",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,DIA_C_U16_DID_RADIO_TYPE_APPROVAL_MODE)
{
   dia_tclFnctTrace trc("dia_SrvHandler_RadioTypeApprovalModeRead::dia_SrvHandler_RadioTypeApprovalModeRead");
}
//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    dia_SrvHandler_RadioTypeApprovalModeRead (Class Destructor)
*
* DESCRIPTION: destroys the instances of the class.
*
* PARAMETER:   void
*
* RETURNVALUE: NA
*
******************************************************************************/
dia_SrvHandler_RadioTypeApprovalModeRead::~dia_SrvHandler_RadioTypeApprovalModeRead ( void )
{
}
//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    vProcessRequest
*
* DESCRIPTION: process the received request
*
* PARAMETER:   -
*
* RETURNVALUE: NA
*
******************************************************************************/
void
dia_SrvHandler_RadioTypeApprovalModeRead::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_RadioTypeApprovalModeRead::vOnProcessRequest");
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength != DATA_LENGHTH )
   {
	   vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
	   return;
   }

   dia_File FlagFile(FILEPATH);
   if (DIA_SUCCESS == FlagFile.open("r"))
   {
	   // Sending back the positive answer
	  FlagFile.close();
   	  DIA_TR_INF("dia_SrvHandler_RadioTypeApprovalModeRead: FILE EXISTS");
   	  oDiagMsgBuffer().vSetPosResp();
   	  oDiagMsgBuffer().vSetDataLength(DATA_LENGHTH);
   	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START, ENABLED);
   }
   else
   {
	   // Sending back the negative answer
	   DIA_TR_INF("dia_SrvHandler_RadioTypeApprovalModeRead::vOnProcessRequest- FILE DOSEN'T EXIST");
	   oDiagMsgBuffer().vSetPosResp();
	   oDiagMsgBuffer().vSetDataLength(DATA_LENGHTH);
   	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START, DISABLED);
   }
   vResReadyAndQuit();
}
