/*
 * dia_SrvHandler_RVC_ControlLineCurrent.cpp
 *
 *  Created on: 18.12.2012
 *      Author: shw2abt
 *
 * 05/07/2017		bma9kor		Modified the RVC current conversion
 */

// TTFis:\> DIA_REQ UDS 04 22 10 22

#include "dia_SrvHandler_RVC_ControlLineCurrent.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 2

#define DIA_MAX_RVC_CURRENT_VALUE   ((tU32)0x0000FFFFU)
#define DIA_RVC_CURRENT_MULTIPLE    10

//-----------------------------------------------------------------------------

dia_SrvHandler_RVC_ControlLineCurrent::dia_SrvHandler_RVC_ControlLineCurrent ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_RVC_ControlLineCurrent",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_RVC_CONTROL_LINE_CURRENT /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_RVC_ControlLineCurrent::dia_SrvHandler_RVC_ControlLineCurrent(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_RVC_ControlLineCurrent::~dia_SrvHandler_RVC_ControlLineCurrent ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IRVCListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_RVC_ControlLineCurrent::~dia_SrvHandler_RVC_ControlLineCurrent !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_RVC_ControlLineCurrent::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_RVC_ControlLineCurrent::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_IRVC* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_IRVC>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_RVC_ControlLineCurrent::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_RVC_ControlLineCurrent::vProcessRequest - pInterface OK.");
         (void) setSysAdapterListener<dia_IRVCListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_RVC_ControlLineCurrent::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->getRVCConnectionInfo() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_RVC_ControlLineCurrent::vProcessRequest - getRVCConnectionInfo() SUCCESS.");
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF("dia_SrvHandler_RVC_ControlLineCurrent::vProcessRequest - getRVCConnectionInfo() FAILED.");
         }
      }
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_RVC_ControlLineCurrent::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IRVCListener>(this);
      DIA_TR_ERR("dia_SrvHandler_RVC_ControlLineCurrent ---  SEND TO RVC SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

void
dia_SrvHandler_RVC_ControlLineCurrent::vOnRVCPowerSupplyCurrent ( tU32 rvc_current )
{
   dia_tclFnctTrace trc("dia_SrvHandler_RVC_ControlLineCurrent::vOnRVC_ControlLineCurrent");

   (void) unsetSysAdapterListener<dia_IRVCListener>(this);
   rvc_current = (tU16)(rvc_current * DIA_RVC_CURRENT_MULTIPLE);

   if(rvc_current < DIA_MAX_RVC_CURRENT_VALUE )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) U32_BYTE3(rvc_current) ));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, ((tU8) U32_BYTE4(rvc_current) ));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_RVC_ControlLineCurrent::vOnRVC_ControlLineCurrent current=0x%04X", rvc_current);
   }
   else
   {
      DIA_TR_ERR("### FAILED Value to large (0x%08X). Max value is 0x%08X", rvc_current, DIA_MAX_RVC_CURRENT_VALUE);
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
