/*
 * dia_SrvHandler_PowerSupplyVoltageStateCounter.cpp
 *
 *  Created on: 19.02.2018
 *      Author: hpe2hi
 */
// TTFis: DIA_REQ UDS 04 22 b1 12
#include "common/services/uds/production/dia_SrvHandler_PowerSupplyVoltageStateCounter.h"

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 16


//-----------------------------------------------------------------------------

dia_SrvHandler_PowerSupplyVoltageStateCounter::dia_SrvHandler_PowerSupplyVoltageStateCounter(void) :
      dia_ServiceHandlerUDS("dia_SrvHandler_PowerSupplyVoltageStateCounter", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE_STATE_COUNTER /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupplyVoltageStateCounter::dia_SrvHandler_PowerSupplyVoltageStateCounter(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_PowerSupplyVoltageStateCounter::~dia_SrvHandler_PowerSupplyVoltageStateCounter(void)
{
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_PowerSupplyVoltageStateCounter::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupplyVoltageStateCounter::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getPowerSupplyVoltageEventCounters() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_PowerSupplyVoltageStateCounter ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

void dia_SrvHandler_PowerSupplyVoltageStateCounter::vOnGetPowerSupplyVoltageEventCounters (dia_tPowerSupplyVoltageEventCounters counters )
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupplyVoltageStateCounter::vOnGetPowerSupplyVoltageEventCounters");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   // Sending back the positive answer
   oDiagMsgBuffer().setDataU32BigEndian(DATA_START +  0, counters.mLowVoltageCount);
   oDiagMsgBuffer().setDataU32BigEndian(DATA_START +  4, counters.mCrLowVoltageCount);
   oDiagMsgBuffer().setDataU32BigEndian(DATA_START +  8, counters.mHighVoltageCount);
   oDiagMsgBuffer().setDataU32BigEndian(DATA_START + 12, counters.mCrHighVoltageCount);

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   DIA_TR_INF("dia_SrvHandler_PowerSupplyVoltageStateCounter::vOnGetPowerSupplyVoltageEventCounters SUCCESSFUL");
   vResReadyAndQuit();
}
