/*
 * dia_SrvHandler_PowerSupplyVoltageHistogram.cpp
 *
 *  Created on: 19.02.2018
 *      Author: hpe2hi
 */
// TTFis: DIA_REQ UDS 04 22 b1 13
#include "common/services/uds/production/dia_SrvHandler_PowerSupplyVoltageHistogram.h"

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 200
#define DATA_ENTRY_SIZE 4
#define DATA_NUM_ENTRIES (DATA_LENGTH / DATA_ENTRY_SIZE)

//-----------------------------------------------------------------------------

dia_SrvHandler_PowerSupplyVoltageHistogram::dia_SrvHandler_PowerSupplyVoltageHistogram(void) :
      dia_ServiceHandlerUDS("dia_SrvHandler_PowerSupplyVoltageHistogram", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE_HISTOGRAM /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupplyVoltageHistogram::dia_SrvHandler_PowerSupplyVoltageHistogram(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_PowerSupplyVoltageHistogram::~dia_SrvHandler_PowerSupplyVoltageHistogram(void)
{
   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_PowerSupplyVoltageHistogram::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupplyVoltageHistogram::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getPowerSupplyVoltageHistogram() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_PowerSupplyVoltageHistogram ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

void dia_SrvHandler_PowerSupplyVoltageHistogram::vOnGetPowerSupplyVoltageHistogram (const std::vector<dia_tSpmVoltageHistogramElement>* histogram )
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupplyVoltageHistogram::vOnGetPowerSupplyVoltageHistogram");

   DIA_TR_INF("dia_SrvHandler_PowerSupplyVoltageHistogram::vOnGetPowerSupplyVoltageHistogram SUCCESSFUL");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   // map received elements to diag-ranges
   std::map<tU32,tU32> mapper;
   for (std::vector<dia_tSpmVoltageHistogramElement>::const_iterator it =  histogram->begin();
        it != histogram->end();
        ++it)
   {
      unsigned int voltageV=it->aVoltageMV/1000;
      printf("peha: adRes voltage=%u mV (%u V): seconds=%u\n", it->aVoltageMV, voltageV , it->mOperationTimeSeconds);
      mapper[it->aVoltageMV/1000]+=it->mOperationTimeSeconds;
      printf("peha: acc %u seconds \n", mapper[it->aVoltageMV/1000]);
   }


   // Sending back the positive answer
   for (unsigned int voltageV=0; voltageV < DATA_NUM_ENTRIES; ++voltageV) {
      unsigned int seconds=mapper[voltageV];
      unsigned int index= voltageV * DATA_ENTRY_SIZE;
      printf("peha: setRes voltage=%u V: seconds=%u\n", voltageV, seconds);
      oDiagMsgBuffer().setDataU32BigEndian ((tU16)(DATA_START + index),  seconds);

   }
   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_PowerSupplyVoltageHistogram::vOnGetPowerSupplyVoltageHistogram SUCCESSFUL");
}
