/*
 * dia_SrvHandler_PowerSupplyStatus.cpp
 *
 *  Created on: 28.01.2014
 *      Author: kth4kor
 */
// TTFis: DIA_REQ UDS 04 22 b1 11
#include "common/services/uds/production/dia_SrvHandler_PowerSupplyStatus.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_PowerSupplyStatus::dia_SrvHandler_PowerSupplyStatus(tVoid) :
      dia_ServiceHandlerUDS("dia_SrvHandler_PowerSupplyStatus", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE_STATE /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupplyStatus::dia_SrvHandler_PowerSupplyStatus(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_PowerSupplyStatus::~dia_SrvHandler_PowerSupplyStatus(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_PowerSupplyStatus::~dia_SrvHandler_PowerSupplyStatus !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

//-------------------------------------------------------------------------------

tVoid dia_SrvHandler_PowerSupplyStatus::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupplyStatus::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getPowerSupplyStatus() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_PowerSupplyStatus ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

void dia_SrvHandler_PowerSupplyStatus::vOnGetPowerSupplyStatus (tU8 voltage)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupplyStatus::vOnGetPowerSupplyStatus");

   DIA_TR_INF("dia_SrvHandler_PowerSupplyStatus::vOnGetPowerSupplyStatus SUCCESSFUL");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   // Sending back the positive answer
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 0,((tU8) voltage));

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_PowerSupplyStatus::vOnGetPowerSupplyStatus SUCCESSFUL");
}
