/*
 * dia_SrvHandler_PowerSupply.cpp
 *
 *  Created on: 28.01.2014
 *      Author: kth4kor
 */
// TTFis: DIA_REQ UDS 04 22 b1 10
#include "common/services/uds/production/dia_SrvHandler_PowerSupply.h"

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_PowerSupply::dia_SrvHandler_PowerSupply(tVoid) :
      dia_ServiceHandlerUDS("dia_SrvHandler_PowerSupply", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupply::dia_SrvHandler_PowerSupply(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_PowerSupply::~dia_SrvHandler_PowerSupply(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_PowerSupply::~dia_SrvHandler_PowerSupply !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

//-------------------------------------------------------------------------------

tVoid dia_SrvHandler_PowerSupply::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupply::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getVoltageSplyTerminalValue() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_PowerSupply ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

void dia_SrvHandler_PowerSupply::vOnGetPowerSupply (tU16 voltage)
{
   dia_tclFnctTrace trc("dia_SrvHandler_PowerSupply::vOnGetPowerSupply");

   DIA_TR_INF("dia_SrvHandler_PowerSupply::vOnGetPowerSupply SUCCESSFUL");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   // Sending back the positive answer
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 0,U16_BYTE1(voltage));
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 1,U16_BYTE2(voltage));

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_PowerSupply::vOnGetPowerSupply SUCCESSFUL");
}
