/*!
 * \file       dia_SrvHandler_ODXFileIdentifier.cpp
 *
 * \brief      Read ODX FileIdentifier with dynamic length
 *
 * \component  Diagnostics
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_ODXFILEIDENTIFIER_H__
#define __INCLUDED_DIA_ODXFILEIDENTIFIER_H__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

class dia_SrvHandler_ODXFileIdentifier : public dia_ServiceHandlerUDS
{
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ODXFileIdentifier);

  public:
    //! class constructor
    dia_SrvHandler_ODXFileIdentifier() : dia_ServiceHandlerUDS("dia_SrvHandler_ODXFileIdentifier"){};

    virtual tVoid vProcessRequest(const std::vector<tArgsType>&);
    virtual tDiaResult makeLookupKeys(std::vector<dia_LookupKey*>&);
  protected:
    //! class destructor
    virtual ~dia_SrvHandler_ODXFileIdentifier(){};
};

#endif /* __INCLUDED_DIA_ODXFILEIDENTIFIER_H__ */
