/*
 * dia_SrvHandler_MaximumRamConsumption.cpp
 *
 *  Created on: 19.02.2018
 *      Author: hpe2hi
 */
// TTFis: DIA_REQ UDS 04 22 b1 15
#include "common/services/uds/production/dia_SrvHandler_MaximumRamConsumption.h"

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 12

//-----------------------------------------------------------------------------

dia_SrvHandler_MaximumRamConsumption::dia_SrvHandler_MaximumRamConsumption(void) :
      dia_ServiceHandlerUDS("dia_SrvHandler_MaximumRamConsumption", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_RBCM_MAXIMUM_RAM_CONSUMPTION /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_MaximumRamConsumption::dia_SrvHandler_MaximumRamConsumption(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_MaximumRamConsumption::~dia_SrvHandler_MaximumRamConsumption(void)
{
   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_MaximumRamConsumption::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_MaximumRamConsumption::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getRamUsageStatistics() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_MaximumRamConsumption ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

void dia_SrvHandler_MaximumRamConsumption::vOnGetRamUsageStatistics (dia_tSpmStatisticData statistics )
{
   dia_tclFnctTrace trc("dia_SrvHandler_MaximumRamConsumption::vOnGetRamUsageStatistics");

   DIA_TR_INF("dia_SrvHandler_MaximumRamConsumption::vOnGetRamUsageStatistics SUCCESSFUL");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   // Sending back the positive answer
   (void) oDiagMsgBuffer().setDataU32BigEndian (DATA_START + 0,  statistics.mMaxValue);
   (void) oDiagMsgBuffer().setDataU32BigEndian (DATA_START + 4,  statistics.mAvgValue);
   (void) oDiagMsgBuffer().setDataU32BigEndian (DATA_START + 8,  statistics.mMinValue);

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_MaximumRamConsumption::vOnGetRamUsageStatistics SUCCESSFUL");
}
