/*******************************************************************************************
 * dia_SrvHandler_InputHdlPressedKey_Get.cpp
 *
 *  Created on: 18.02.2014
 *      Author: wgl2hi

// TTFis:\> DIA_REQ UDS 03 22 62 30
 * ------------------------------------------------------------------------------------------
 * Date 			| Author			 | Modification
 * 27.11.15    		| ata7kor	  		 | Added a code change to resolve ticket AIVI-15132
 *
 * ------------------------------------------------------------------------------------------

 ********************************************************************************************/

#ifndef DIA_SRVHANDLER_INPUT_HDL_PRESSED_KEY_GET_H_
#include "dia_SrvHandler_InputHdlPressedKey_Get.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif
#ifndef __INCLUDED_DIA_DEFS_COMMON__
#include "common/framework/application/dia_defsCommon.h"
#endif
#define DATA_START 3
#define DATA_LENGTH 2

// convert DIA key code to native (in IPSIM component) defined key code
tU16 aDiagInternalKeyCode[DIA_KEY_CODE_COUNT] =
{
   0xFFFF,
   0x0300,
   0x0301,
   0x0302,
   0x0303,
   0x0304,
   0x0305,
   0x0306,
   0x0307,
   0x0308,
   0x0309,
   0x030A,
   0x030B,
   0x030C,
   0x030D,
   0x030E,
   0x0311,
   0x0312,
   0x0313,
   0x0314,
   0x0315,
   0x03A0,
   0x030F,
   0x0310,
   0X0064,
   0X0065,
   0X0066,
   0X0067,
   0X0068,
   0X006A,
   0X006B,
   0X006C,
   0X006D,
   0X006F,
   0X0070,
   0X0071,
   0X0072,
   0X0073,
   0X0074
};

//-----------------------------------------------------------------------------

dia_SrvHandler_InputHdlPressedKey_Get::dia_SrvHandler_InputHdlPressedKey_Get ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_InputHdlPressedKey_Get",
	  DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
	  (tU16) DIA_C_U16_DID_RBCM_INPUT_HDL_KEY_PRESSED /*DID*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputHdlPressedKey_Get::dia_SrvHandler_InputHdlPressedKey_Get(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_InputHdlPressedKey_Get::~dia_SrvHandler_InputHdlPressedKey_Get ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_InputHdlPressedKey_Get::~dia_SrvHandler_InputHdlPressedKey_Get !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputHdlPressedKey_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputHdlPressedKey_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IInputHandling* pInterface = 0;
   if ( querySysAdapterInterface<dia_IInputHandling>(&pInterface) == DIA_SUCCESS )
   {
   	  DIA_TR_INF("dia_SrvHandler_InputHdlPressedKey_Get::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
      	(void) setSysAdapterListener<dia_IInputHandlingListener>(this);
         if ( pInterface->getPressedKeys () == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
		 else
		 {
         	DIA_TR_INF("dia_SrvHandler_InputHdlPressedKey_Get::vProcessRequest - getPressedKeys() failed.");
         }
      }
   }
   else
   {
   	  DIA_TR_INF("dia_SrvHandler_InputHdlPressedKey_Get::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
      DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_InputHdlPressedKey_Get::vOnGetPressedKey ( const std::vector<tU8> pressedKeys )
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputHdlPressedKey_Get:vOnGetPressedKey");

   (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   tU16 u16Size = (tU16) pressedKeys.size();
   tU16 internalKey;
   if ((u16Size > 0) && (pressedKeys[0] < (sizeof (aDiagInternalKeyCode) / sizeof (tU16))))
   {
      internalKey = aDiagInternalKeyCode[pressedKeys[0]];
   }
   else
   {
      internalKey = aDiagInternalKeyCode[DIA_EN_KEY_CODE_UNKNOWN];
   }

   (void) oDiagMsgBuffer().vSetDataU8(DATA_START, (tU8) (internalKey >> 8));
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+1, (tU8) internalKey);

   (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
   vResReadyAndQuit();
}
//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    vOnGetPressedKeyError
*
* DESCRIPTION: Handle the error and unset the InputHandlingListener
*
* PARAMETER:    none
			    none
*
* RETURNVALUE: none
*              none
*
******************************************************************************/
void
dia_SrvHandler_InputHdlPressedKey_Get::vOnGetPressedKeyError( void )
{
	(void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
	DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
	vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
}
//-----------------------------------------------------------------------------
