/*
 * dia_SrvHandler_HistoryWakeup.h
 *
 *  Created on: 12.03.2013
 *      Author: shw2abt
 */

#ifndef DIA_SRVHANDLER_HISTORYWAKEUP_H_
#define DIA_SRVHANDLER_HISTORYWAKEUP_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

class dia_SrvHandler_HistoryWakeup
   : public dia_ServiceHandlerUDS,
     public dia_ISpmListenerImpl
{
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_HistoryWakeup);


public:
   //! class constructor
      dia_SrvHandler_HistoryWakeup ( tVoid );

   /**
     * \brief    	handle the received request
     *
     *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *				The SystemAdapter returns the reset history
     *
     * \param[in]	const std::vector<tVoid*>&      not used here
     */
   virtual tVoid vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief    	status for the requested wakeup history
     *
     *				Function receives the message via its parameter and send it to the tester.
     *				It verifies the SA answer and send the wakeup history list to the tester.
     *
     * \param[in]	const std::vector<tU8>* wakeupElements
     */
    virtual tVoid vOnGetWakeUpHistory ( const std::vector<tU8>* wakeupElements );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_HistoryWakeup(tVoid);

};


#endif /* DIA_SRVHANDLER_HISTORYWAKEUP_H_ */
