/*
 * dia_SrvHandler_HistoryErrState.h
 *
 *  Created on: 12.03.2013
 *      Author: shw2abt
 */

#ifndef DIA_SRVHANDLER_HISTORYERRSTATE_H_
#define DIA_SRVHANDLER_HISTORYERRSTATE_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

class dia_SrvHandler_HistoryErrState
   : public dia_ServiceHandlerUDS,
     public dia_ISpmListenerImpl
{
    DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandler_HistoryErrState);
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_HistoryErrState);


public:
   //! class constructor
      dia_SrvHandler_HistoryErrState ( tCString name, tU8 sid, tU16 did , tU8 ErrStateId);

   //! class destructor
   virtual ~dia_SrvHandler_HistoryErrState(tVoid);

   /**
     * \brief    	handle the received request
     *
    *				Function recieves the message via the oDiagMsgBuffer and send it to the SA.
    *				The SystemAdapter analysis the data and send it via CCA to the responsible component.
     *
     * \param[in]	const std::vector<tVoid*>&      not used here
     */
   virtual tVoid vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief    	status for the requested error state  history
     *
     *				Function receives the message via its parameter and send it to the tester.
     *				It verifies the SA answer and send the error state  history list to the tester.
     *
     * \param[in]	 dia_eSpmErrState errState - number of read error state history
     * \param[in]  const std::vector<tU8>* errStateElements
     */
   virtual tVoid vOnGetErrStateHistory ( dia_eSpmErrState errState, const std::vector<tU8>* errStateElements );

protected:

   tU8 mErrStateID;
};


#endif /* DIA_SRVHANDLER_HISTORYERRSTATE_H_ */
