/*
 * dia_SrvHandler_HistoryErrState.cpp
 *
 *  Created on: 02.03.2013
 *      Author: shw2abt
 */
// TTFis: DIA_REQ UDS 04 22 10 XX (XX = 33 ... 37)
#include "common/services/uds/production/dia_SrvHandler_HistoryErrState.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define ERROR_STATE_HISTORY_ELEMENT_SIZE        41 /* bytes */
#define ERROR_STATE_HISTORY_NUMBER_OF_ELEMENT   50
#define ERROR_STATE_HISTORY_ELEMENTS_LIMIT ((ERROR_STATE_HISTORY_ELEMENT_SIZE)*(ERROR_STATE_HISTORY_NUMBER_OF_ELEMENT))

//-----------------------------------------------------------------------------

dia_SrvHandler_HistoryErrState::dia_SrvHandler_HistoryErrState( tCString name, tU8 sid, tU16 did , tU8 ErrStateId ) :
      dia_ServiceHandlerUDS(name,sid,(tU16) did),
      mErrStateID(ErrStateId)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryErrState::dia_SrvHandler_HistoryErrState(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_HistoryErrState::~dia_SrvHandler_HistoryErrState(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_HistoryErrState::~dia_SrvHandler_HistoryErrState !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_HistoryErrState::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryErrState::vProcessRequest");

   tDiaResult errorDetected = DIA_E_ERROR;

   dia_ISpm* pSpm = 0;
   if ((querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) && (oDiagMsgBuffer().u16GetDataLength() == 0x04))
   {
      if (pSpm)
      {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         DIA_TR_INF("dia_SrvHandler_HistoryErrState::vProcessRequest - errState = 0x%02x .", mErrStateID);
         if( (mErrStateID > DIA_EN_SPM_ERR_STATE_UNKNOWN) && (mErrStateID < DIA_EN_SPM_ERR_STATE_COUNT) )
         {
            if( DIA_SUCCESS == pSpm->getErrStateHistory((dia_eSpmErrState)mErrStateID) )
            {
               errorDetected = DIA_E_NOERROR;
               DIA_TR_ERR("dia_SrvHandler_HistoryErrState::vProcessRequest Req sent to SPM");
            }
         }
         else
         {
            DIA_TR_ERR("dia_SrvHandler_HistoryErrState::vProcessRequest INVALID ERR STATE.");
         }
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_HistoryErrState::vProcessRequest ERR querySysAdapter==FALSE || oDiagMsgBuffer.Length!=4 => %d .", oDiagMsgBuffer().u16GetDataLength());
   }

   if (DIA_E_NOERROR != errorDetected) {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_HistoryErrState ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void dia_SrvHandler_HistoryErrState::vOnGetErrStateHistory( dia_eSpmErrState errState, const std::vector<tU8>* errStateElements )
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryErrState::vOnGetErrStateHistory");

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);

   if (errState != DIA_EN_SPM_ERR_STATE_UNKNOWN && errState < DIA_EN_SPM_ERR_STATE_COUNT)
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + ERROR_STATE_HISTORY_ELEMENTS_LIMIT);

      DIA_TR_INF("dia_SrvHandler_HistoryErrState::vOnGetErrStateHistory - errState = 0x%02x", errState);

      tU16 i = 0;

      //copy bytes from input buffer to sending buffer
      for (std::vector<tU8>::const_iterator it=errStateElements->begin();
            (it!=errStateElements->end()) && (i<ERROR_STATE_HISTORY_ELEMENTS_LIMIT); ++it, ++i)
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + i), *it);
      }

      if (ERROR_STATE_HISTORY_ELEMENTS_LIMIT!=i)
      {
         DIA_TR_ERR("dia_SrvHandler_HistoryErrState::vOnGetErrStateHistory Only %d elements in state history", i);
      }

      //zero for any missing bytes
      for (; i < ERROR_STATE_HISTORY_ELEMENTS_LIMIT; i++)
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + i), 0);
      }

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_HistoryErrState::vOnGetErrStateHistory SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_HistoryErrState::vOnGetErrStateHistory FAIL errState=%d", errState);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

