/*
 * dia_SrvHandler_GetSystemResetInformation.cpp
 *
 *  Created on: 25.05.2012
 *      Author: shw2abt
 */

// TTFis:\> DIA_REQ UDS 04 22 10 00

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#include "dia_SrvHandler_GetSystemResetInformation.h"

#define DATA_START 3
#define DATA_LENGTH 96

//-----------------------------------------------------------------------------

dia_SrvHandler_GetSystemResetInformation::dia_SrvHandler_GetSystemResetInformation ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_GetSystemResetInformation",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_SYSTEM_RESET_INFORMATION /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetSystemResetInformation::dia_SrvHandler_GetSystemResetInformation(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GetSystemResetInformation::~dia_SrvHandler_GetSystemResetInformation ( void )
{
   _BP_TRY_BEGIN
   {
    (void) unsetSysAdapterListener<dia_ISpmListener>(this);   // dia_IHeatControlListener
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GetSystemResetInformation::~dia_SrvHandler_GetSystemResetInformation !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_GetSystemResetInformation::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetSystemResetInformation::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pInterface = 0;
   if ( querySysAdapterInterface<dia_ISpm>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if ( pInterface->getSystemResetInformation() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_GetSystemResetInformation ---  SEND TO SPM SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_GetSystemResetInformation::vOnSystemResetStatus ( const dia_tSpmResetStatus* pStatus ){

   dia_tclFnctTrace trc("dia_SrvHandler_GetSystemResetInformation::vOnSystemResetStatus");

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);

   if ( NULL!=pStatus )
   {
      DIA_TR_INF("dia_SrvHandler_GetSystemResetInformation::vOnSystemResetStatus SUCCESSFUL");

      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0,  ((tU8) pStatus->mLastResetReason ));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 1,  ((tU8) pStatus->mDateHour));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 2,  ((tU8) pStatus->mDateMinute));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 3,  ((tU8) pStatus->mDateDay));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 4,  ((tU8) pStatus->mDateMonth));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 5,  ((tU8) (pStatus->mDateYear >> 8)));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 6,  ((tU8) pStatus->mDateYear));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 7,  ((tU8) pStatus->mCoproResetByHmi));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 8,  ((tU8) pStatus->mCoproResetByUndervoltage));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 9,  ((tU8) pStatus->mHmiResetByCoproStartup));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 10, ((tU8) pStatus->mHmiResetByCoproRun));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 11, ((tU8) pStatus->mHmiResetByCoproShutdown));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 12, ((tU8) pStatus->mHmiResetByHmiWdg));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 13, ((tU8) pStatus->mHmiResetByHmiApp));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 14, ((tU8) pStatus->mHmiResetByHmiException));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 15, ((tU8) pStatus->mHmiResetByHmiExtern));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 16, ((tU8) pStatus->mHmiResetByHmiDownload));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 17, ((tU8) pStatus->mHmiResetByHmiDiag));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 18, ((tU8) pStatus->mFgsResetByHmi));

      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_GetSystemResetInformation::vOnSystemResetStatus FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_GetSystemResetInformation::vOnSystemResetInformation ( const dia_tSpmResetDate* pDate, const dia_tSpmResetCounterStatus* pStatus ){

   dia_tclFnctTrace trc("dia_SrvHandler_GetSystemResetInformation::vOnSystemResetInformation");

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);

   if ( NULL!=pStatus && NULL!=pDate )
   {
      DIA_TR_INF("dia_SrvHandler_GetSystemResetInformation::vOnSystemResetInformation SUCCESSFUL");

      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0,  ((tU8) pStatus->mLastResetReason ));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 1,  ((tU8)(pDate->mDateYear >> 8)));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 2,  ((tU8) pDate->mDateYear ));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 3,  ((tU8) pDate->mDateMonth ));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 4,  ((tU8) pDate->mDateDay ));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 5,  ((tU8) pDate->mDateHour ));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 6,  ((tU8) pDate->mDateMinute ));
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 7,  ((tU8) pDate->mDateSecond ));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 8,  ((tU8)(pStatus->mApApplicationError >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 9,  ((tU8)(pStatus->mApApplicationError >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 10, ((tU8)(pStatus->mApApplicationError >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 11, ((tU8)(pStatus->mApApplicationError >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 12, ((tU8)(pStatus->mApSoftware >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 13, ((tU8)(pStatus->mApSoftware >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 14, ((tU8)(pStatus->mApSoftware >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 15, ((tU8)(pStatus->mApSoftware >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 16, ((tU8)(pStatus->mApEcuReset >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 17, ((tU8)(pStatus->mApEcuReset >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 18, ((tU8)(pStatus->mApEcuReset >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 19, ((tU8)(pStatus->mApEcuReset >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 20, ((tU8)(pStatus->mApDownload >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 21, ((tU8)(pStatus->mApDownload >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 22, ((tU8)(pStatus->mApDownload >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 23, ((tU8)(pStatus->mApDownload >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 24, ((tU8)(pStatus->mApDownloadError >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 25, ((tU8)(pStatus->mApDownloadError >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 26, ((tU8)(pStatus->mApDownloadError >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 27, ((tU8)(pStatus->mApDownloadError >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 28, ((tU8)(pStatus->mApOvertemperature >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 29, ((tU8)(pStatus->mApOvertemperature >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 30, ((tU8)(pStatus->mApOvertemperature >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 31, ((tU8)(pStatus->mApOvertemperature >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 32, ((tU8)(pStatus->mApUser >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 33, ((tU8)(pStatus->mApUser >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 34, ((tU8)(pStatus->mApUser >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 35, ((tU8)(pStatus->mApUser >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 36, ((tU8)(pStatus->mApLcmIntern >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 37, ((tU8)(pStatus->mApLcmIntern >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 38, ((tU8)(pStatus->mApLcmIntern >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 39, ((tU8)(pStatus->mApLcmIntern >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 40, ((tU8)(pStatus->mApWarmstartCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 41, ((tU8)(pStatus->mApWarmstartCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 42, ((tU8)(pStatus->mApWarmstartCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 43, ((tU8)(pStatus->mApWarmstartCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 44, ((tU8)(pStatus->mApPowerOnCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 45, ((tU8)(pStatus->mApPowerOnCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 46, ((tU8)(pStatus->mApPowerOnCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 47, ((tU8)(pStatus->mApPowerOnCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 48, ((tU8)(pStatus->mApPowerLossCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 49, ((tU8)(pStatus->mApPowerLossCount)));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 50, ((tU8)(pStatus->mApPowerLossCount)));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 51, ((tU8)(pStatus->mApPowerLossCount)));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 52, ((tU8)(pStatus->mApPowerOffCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 53, ((tU8)(pStatus->mApPowerOffCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 54, ((tU8)(pStatus->mApPowerOffCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 55, ((tU8)(pStatus->mApPowerOffCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 56, ((tU8)(pStatus->mApSccCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 57, ((tU8)(pStatus->mApSccCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 58, ((tU8)(pStatus->mApSccCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 59, ((tU8)(pStatus->mApSccCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 60, ((tU8)(pStatus->mApUnknownCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 61, ((tU8)(pStatus->mApUnknownCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 62, ((tU8)(pStatus->mApUnknownCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 63, ((tU8)(pStatus->mApUnknownCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 64, ((tU8)(pStatus->mSccHwWdtCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 65, ((tU8)(pStatus->mSccHwWdtCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 66, ((tU8)(pStatus->mSccHwWdtCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 67, ((tU8)(pStatus->mSccHwWdtCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 68, ((tU8)(pStatus->mSccPowerOnCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 69, ((tU8)(pStatus->mSccPowerOnCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 70, ((tU8)(pStatus->mSccPowerOnCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 71, ((tU8)(pStatus->mSccPowerOnCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 72, ((tU8)(pStatus->mSccColdstartCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 73, ((tU8)(pStatus->mSccColdstartCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 74, ((tU8)(pStatus->mSccColdstartCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 75, ((tU8)(pStatus->mSccColdstartCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 76, ((tU8)(pStatus->mSccAppmodeChangeCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 77, ((tU8)(pStatus->mSccAppmodeChangeCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 78, ((tU8)(pStatus->mSccAppmodeChangeCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 79, ((tU8)(pStatus->mSccAppmodeChangeCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 80, ((tU8)(pStatus->mSccDuringLpwCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 81, ((tU8)(pStatus->mSccDuringLpwCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 82, ((tU8)(pStatus->mSccDuringLpwCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 83, ((tU8)(pStatus->mSccDuringLpwCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 84, ((tU8)(pStatus->mSccDuringPllOszCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 85, ((tU8)(pStatus->mSccDuringPllOszCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 86, ((tU8)(pStatus->mSccDuringPllOszCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 87, ((tU8)(pStatus->mSccDuringPllOszCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 88, ((tU8)(pStatus->mSccDuringSWCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 89, ((tU8)(pStatus->mSccDuringSWCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 90, ((tU8)(pStatus->mSccDuringSWCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 91, ((tU8)(pStatus->mSccDuringSWCount >> 0 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 92, ((tU8)(pStatus->mSccWarmstartCount >> 24 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 93, ((tU8)(pStatus->mSccWarmstartCount >> 16 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 94, ((tU8)(pStatus->mSccWarmstartCount >> 8 )));
	  (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 95, ((tU8)(pStatus->mSccWarmstartCount >> 0 )));

      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_GetSystemResetInformation::vOnSystemResetInformation FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
