/*
 * dia_SrvHandler_GetSystemOperationTime.cpp
 *
 *  Created on: 25.05.2012
 *      Author: shw2abt
 */

// TTFis:\> DIA_REQ UDS 04 22 B1 01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#include "dia_SrvHandler_GetSystemOperationTime.h"

#define DATA_START 3
#define DATA_LENGTH 4

//-----------------------------------------------------------------------------

dia_SrvHandler_GetSystemOperationTime::dia_SrvHandler_GetSystemOperationTime ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_GetSystemOperationTime",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_SYSTEM_OPERATION_TIME /*DID*/) //
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetSystemOperationTime::dia_SrvHandler_GetSystemOperationTime(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GetSystemOperationTime::~dia_SrvHandler_GetSystemOperationTime ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GetSystemOperationTime::~dia_SrvHandler_GetSystemOperationTime !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_GetSystemOperationTime::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetSystemOperationTime::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpmTimerIntervall* pInterface = 0;
   if ( querySysAdapterInterface<dia_ISpmTimerIntervall>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         (tVoid) setSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
         if ( pInterface->getSpmTimerIntervall(DIA_EN_SPM_TIMERINTERVALL_ID_OPERATION_COUNTER) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
      DIA_TR_ERR(" dia_SrvHandler_GetSystemOperationTime ---  SEND TO SPM SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_GetSystemOperationTime::vOnSpmTimerIntervall ( dia_eSpmTimerIntervallID id, tU32 timerIntervall )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetSystemOperationTime::vOnSpmTimeValue");

   (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);

   if (id == DIA_EN_SPM_TIMERINTERVALL_ID_OPERATION_COUNTER)
   {
      DIA_TR_INF("dia_SrvHandler_GetSystemOperationTime::vOnSpmTimerIntervall SUCCESSFUL");

      // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) (timerIntervall >> 24)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, ((tU8) (timerIntervall >> 16)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 2, ((tU8) (timerIntervall >> 8)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 3, ((tU8) (timerIntervall)));

      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_GetSystemOperationTime::vOnSpmTimerIntervall FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
