/*
 * dia_SrvHandler_GNSSReceiverStatus_Get.h
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 */

#ifndef dia_SrvHandler_GNSSRECEIVERSTATUS_GET_H_
#define dia_SrvHandler_GNSSRECEIVERSTATUS_GET_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#include "common/interfaces/dia_IGNSSListener.h"
#endif


class dia_SrvHandler_GNSSReceiverStatus_Get
   : public dia_ServiceHandlerUDS,
     public dia_IGNSSListenerImpl
{
   	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_GNSSReceiverStatus_Get);


public:
   //! class constructor
   	dia_SrvHandler_GNSSReceiverStatus_Get ( );

	/**
	  * \brief    	handle the received request
	  *
	  *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
	  *				The SystemAdapter returns the current of the GNSS antenna.
	  *
	  * \param[in]	tVoid*     -
	  * \param[in]	tVoid*     -
	  */
	virtual tVoid vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

	/**
	  * \brief    	status for the requested the current of the GNSS antenna
	  *
	  *				Function recieves the message via its parameter and send it to the tester.
     *				It verifies the SA answer and send the expected value to the tester.
	  *
	  * \param[in]	midw_ext_fi_tclString btDeviceAddr	BT Device Name String
	  * \param[in]	tU32 btDeviceAddr_size length of btDeviceAddr
	  */
	virtual tVoid vOnGNSSReceiverStatus  ( const dia_tGNSSReceiverState& info );


protected:
	//! class destructor
	virtual ~dia_SrvHandler_GNSSReceiverStatus_Get();

};


#endif /* dia_SrvHandler_GNSSRECEIVERSTATUS_GET_H_ */
