/*
 * dia_SrvHandler_GNSSReceiverFirmwareVersion_Get.cpp
 *
 *  Created on: 31.07.2014
 *      Author: bhs1hi
 */
 // TTFis: DIA_REQ UDS 03 22 70 30

#ifndef __INCLUDED_DIA_SRV_GNSS_REC_FIRMWARE_VERSION_GET_H_
#include "dia_SrvHandler_GNSSReceiverFirmwareVersion_Get.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#define DATA_START 3

//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::dia_SrvHandler_GNSSReceiverFirmwareVersion_Get ( )
    : dia_ServiceHandlerUDS("dia_SrvHandler_GNSSReceiverFirmwareVersion_Get",
          DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
          DIA_C_U16_DID_RBCM_GNSS_REC_FIRMWARE_VERSION)

{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::dia_SrvHandler_GNSSReceiverFirmwareVersion_Get(void)");
}
//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::~dia_SrvHandler_GNSSReceiverFirmwareVersion_Get( )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::~dia_SrvHandler_GNSSReceiverFirmwareVersion_Get !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}
//-------------------------------------------------------------------------------

void
dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::vProcessRequest");
   tBool errorDetected = TRUE;
   dia_IGNSS* pGNSS = 0;
   if ( querySysAdapterInterface<dia_IGNSS>(&pGNSS) == DIA_SUCCESS )
   {
      if ( pGNSS )
      {
         (void) setSysAdapterListener<dia_IGNSSListener>(this);
         if ( pGNSS->getGNSSConfigData() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }
   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
      DIA_TR_ERR("dia_SrvHandler_GNSSReceiverFirmwareVersion_Get ---  SEND TO GNSS_Sensor Component failed!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}
//-----------------------------------------------------------------------------

void
dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::vOnGNSSRecFirmwareVersion  ( const tU32 firmwareVersion )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::vOnGNSSRecFirmwareVersion");

   DIA_TR_INF("dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::vOnGNSSRecFirmwareVersion firmwareVersion = %d.", ((tU32)firmwareVersion));
   DIA_TR_INF("dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::vOnGNSSRecFirmwareVersion firmwareVersion = 0x%08x.", firmwareVersion);

   tChar buffer [12];
   snprintf (buffer, 12, "%02X.%02X.%02X.%02X", (tU8) U32_BYTE1(firmwareVersion), (tU8) U32_BYTE2(firmwareVersion), (tU8) U32_BYTE3(firmwareVersion), (tU8) U32_BYTE4(firmwareVersion));
   DIA_TR_INF("dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::vOnGNSSRecFirmwareVersion buffer = %s.", buffer);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START+ 11);

   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+0, buffer[0]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+1, buffer[1]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+2, buffer[2]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+3, buffer[3]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+4, buffer[4]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+5, buffer[5]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+6, buffer[6]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+7, buffer[7]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+8, buffer[8]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+9, buffer[9]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+10, buffer[10]);

   (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_GNSSReceiverFirmwareVersion_Get::vOnGNSSReceiverStatus SUCCESSFUL");
}
