/*
 * dia_SrvHandler_GNSSPositioningSystem_Get.cpp
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 *	--------------------------------------------------------
 * 	Date 	       | Author	          | Modification
 * 	29.03.16       | bsu9kor          | DID Changed to 0x6307 (NCG3D-7749).
 * 	----------------------------------------------------------
 */
// TTFis: DIA_REQ UDS 04 22 63 07

#include "dia_SrvHandler_GNSSPositioningSystem_Get.h"

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#include "common/interfaces/dia_IGNSSListener.h"
#endif

#define DATA_START 3


//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSPositioningSystem_Get::dia_SrvHandler_GNSSPositioningSystem_Get ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_GNSSPositioningSystem_Get",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,DIA_C_U16_DID_SENSOR_GNSS_POS_SYSTEM /*DID*/)

{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSPositioningSystem_Get::dia_SrvHandler_GNSSPositioningSystem_Get(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSPositioningSystem_Get::~dia_SrvHandler_GNSSPositioningSystem_Get( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GNSSPositioningSystem_Get::~dia_SrvHandler_GNSSPositioningSystem_Get !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_GNSSPositioningSystem_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSPositioningSystem_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IGNSS* pGNSS = 0;
   if ( querySysAdapterInterface<dia_IGNSS>(&pGNSS) == DIA_SUCCESS )
   {
      if ( pGNSS )
      {
         (void) setSysAdapterListener<dia_IGNSSListener>(this);
         //if ( pGNSS->getGNSSSystem() == DIA_SUCCESS )
	     if ( pGNSS->getDiagGNSSSystem() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
      DIA_TR_ERR(" ---  SEND TO GNSS_Sensor Componente faild!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_GNSSPositioningSystem_Get::vOnGNSSSatSystem  (tU8 GNSSSatSystem)
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSPositioningSystem_Get::vOnGNSSSatSystem");

   (void) unsetSysAdapterListener<dia_IGNSSListener>(this);

   //2017-02-20: Multiple Sat Systems are possible at the same time
   DIA_TR_INF("--- GNSSSatSystem: 0x%x", GNSSSatSystem);
   DIA_TR_INF("--- GNSSSatSystem: GPS: %s", GNSSSatSystem & (1 << 0)? "yes": "no");
   DIA_TR_INF("--- GNSSSatSystem: Glonass: %s", GNSSSatSystem & (1 << 1)? "yes": "no");
   DIA_TR_INF("--- GNSSSatSystem: Galileo: %s", GNSSSatSystem & (1 << 2)? "yes": "no");
   DIA_TR_INF("--- GNSSSatSystem: Compass: %s", GNSSSatSystem & (1 << 3)? "yes": "no");
   DIA_TR_INF("--- GNSSSatSystem: SBAS: %s", GNSSSatSystem & (1 << 4)? "yes": "no");
   DIA_TR_INF("--- GNSSSatSystem: QZSS: %s", GNSSSatSystem & (1 << 5)? "yes": "no");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START+ 1);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+0,(tU8) GNSSSatSystem);

   vResReadyAndQuit();
}

