/*
 * dia_SrvHandler_GNSSBestSattelites_Get.cpp
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 */
// TTFis: DIA_REQ UDS 04 22 63 01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#include "dia_SrvHandler_GNSSBestSattelites_Get.h"

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#include "common/interfaces/dia_IGNSSListener.h"
#endif

#define DATA_START 3


//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSBestSattelites_Get::dia_SrvHandler_GNSSBestSattelites_Get ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_GNSSBestSattelites_Get",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_GNSS_SATELLITE_SIG_QUALITY /*DID*/)

{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSBestSattelites_Get::dia_SrvHandler_GNSSBestSattelites_Get(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSBestSattelites_Get::~dia_SrvHandler_GNSSBestSattelites_Get( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_IGNSSListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GNSSBestSattelites_Get::~dia_SrvHandler_GNSSBestSattelites_Get !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSBestSattelites_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSBestSattelites_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IGNSS* pGNSS = 0;
   if ( querySysAdapterInterface<dia_IGNSS>(&pGNSS) == DIA_SUCCESS )
   {
      if ( pGNSS )
      {
         (tVoid) setSysAdapterListener<dia_IGNSSListener>(this);
         if ( pGNSS->getGNSSData() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IGNSSListener>(this);
      DIA_TR_ERR(" ---  SEND TO GNSS_Sensor Componente faild!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSBestSattelites_Get::vOnGNSSBestSattelites ( const std::vector<dia_tGNSSBestSattelletes>& quality )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSBestSattelites_Get::vOnGNSSBestSattelites");

   (tVoid) unsetSysAdapterListener<dia_IGNSSListener>(this);

   if ( !(quality.empty()) )
   {
       oDiagMsgBuffer().vSetPosResp();
       oDiagMsgBuffer().vSetDataLength(DATA_START+ 8);

       std::vector<dia_tGNSSBestSattelletes>::const_iterator it = quality.begin();
       for ( int i=0 ; it != quality.end(); ++it, i+=2 )
       {
          (tVoid) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+i+0),(tU8) it->m_u8SatellitesNumber);
          (tVoid) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+i+1),(tU8) it->m_u8SignalQuality);

          DIA_TR_INF("m_u8SatellitesNumber = %d", it->m_u8SatellitesNumber);
          DIA_TR_INF("m_u8SignalQuality = %d", it->m_u8SignalQuality);
       }

       vResReadyAndQuit();
       DIA_TR_INF("dia_SrvHandler_GNSSBestSattelites_Get::vOnGNSSBestSattelites SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_GNSSBestSattelites_Get::vOnGNSSBestSattelites FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

