/*
 * dia_SrvHandler_GNSSAntennaStatus_Get.cpp
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 */
// TTFis: DIA_REQ UDS 04 22 63 01

#include "dia_SrvHandler_GNSSAntennaStatus_Get.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3

#define ANTENNA_STATUS_UNKNOWN		  0xFF
#define ANTENNA_STATUS_OK			  0x00
#define ANTENNA_STATUS_OPEN			  0x01
#define ANTENNA_STATUS_SHORT		  0x02
#define ANTENNA_STATUS_SHORT_ACROSS   0x03
#define ANTENNA_STATUS_SHORT_BATTERY  0x04
#define ANTENNA_STATUS_SHORT_GROUND   0x05
#define ANTENNA_STATUS_OPEN_AMPLIFIER 0x06

static tU8 antStatusMapping[DIA_EN_TUNERMASTER_ANTENNASTATUS_COUNT] = {
		ANTENNA_STATUS_UNKNOWN,
		ANTENNA_STATUS_OK,
		ANTENNA_STATUS_OPEN,
		ANTENNA_STATUS_SHORT,
		ANTENNA_STATUS_SHORT_ACROSS,
		ANTENNA_STATUS_SHORT_BATTERY,
		ANTENNA_STATUS_SHORT_GROUND,
		ANTENNA_STATUS_UNKNOWN
      };

//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSAntennaStatus_Get::dia_SrvHandler_GNSSAntennaStatus_Get ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_GNSSAntennaStatus_Get",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_GNSS_ANTENNA_STATUS /*DID*/)

{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSAntennaStatus_Get::dia_SrvHandler_GNSSAntennaStatus_Get(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSAntennaStatus_Get::~dia_SrvHandler_GNSSAntennaStatus_Get( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GNSSAntennaStatus_Get::~dia_SrvHandler_GNSSAntennaStatus_Get !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSAntennaStatus_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSAntennaStatus_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ITunerMaster* pGNSS = 0;
   if ( querySysAdapterInterface<dia_ITunerMaster>(&pGNSS) == DIA_SUCCESS )
   {
      if ( pGNSS )
      {
         (tVoid) setSysAdapterListener<dia_ITunerMasterListener>(this);
         if ( pGNSS->getGNSSExtendedData() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
      DIA_TR_ERR(" ---  SEND TO GNSS_Sensor Componente faild!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSAntennaStatus_Get::vOnGNSSAntennaStatus  (tU8 GNSSAntennaStatus )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSAntennaStatus_Get::vOnGNSSAntennaStatus");

   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);

   if (( GNSSAntennaStatus < DIA_EN_TUNERMASTER_ANTENNASTATUS_COUNT )/* || ( GNSSAntennaStatus == DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN)*/)
   {
	  tU8 antStatus = antStatusMapping[GNSSAntennaStatus];
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START+ 1);
      DIA_TR_INF("Status = %d",GNSSAntennaStatus);
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START+0,(tU8) antStatus);

       vResReadyAndQuit();
       DIA_TR_INF("dia_SrvHandler_GNSSAntennaStatus_Get::vOnGNSSAntennaStatus SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_GNSSAntennaStatus_Get::vOnGNSSAntennaStatus FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void dia_SrvHandler_GNSSAntennaStatus_Get::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_GNSSAntennaStatus_Get::vOnTimeout(void)");
   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();
}

