/*
 * dia_SrvHandler_GNSSAntennaCurrent_Get.cpp
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 */
// TTFis: DIA_REQ UDS 04 22 63 02

#include "dia_SrvHandler_GNSSAntennaCurrent_Get.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3

//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSAntennaCurrent_Get::dia_SrvHandler_GNSSAntennaCurrent_Get ( tVoid )
   : dia_ServiceHandlerUDS("dia_SrvHandler_GNSSAntennaCurrent_Get",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) 0x6302 /*DID*/)

{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSAntennaCurrent_Get::dia_SrvHandler_GNSSAntennaCurrent_Get(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSAntennaCurrent_Get::~dia_SrvHandler_GNSSAntennaCurrent_Get( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GNSSAntennaCurrent_Get::~dia_SrvHandler_GNSSAntennaCurrent_Get !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSAntennaCurrent_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSAntennaCurrent_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ITunerMaster* pGNSS = 0;
   if ( (querySysAdapterInterface<dia_ITunerMaster>(&pGNSS) == DIA_SUCCESS) && pGNSS )
   {
      (tVoid) setSysAdapterListener<dia_ITunerMasterListener>(this);
      if ( pGNSS->getGNSSAntennaCurrent() == DIA_SUCCESS )
      {
         errorDetected = FALSE;
      }
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
      DIA_TR_ERR(" ---  SEND TO GNSS_Sensor Componente faild!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSAntennaCurrent_Get::vOnGNSSAntennaCurrent  ( tU16 GNSSAntennaCurrent )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSAntennaCurrent_Get::vOnGNSSAntennaCurrentResponse");

   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);

   if ( GNSSAntennaCurrent < 256 )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START+ 2);

      tU16 tU16antennaCurrent = (tU16) (GNSSAntennaCurrent * 10);
      DIA_TR_INF("Current(mA) = %u (float)",GNSSAntennaCurrent);
      DIA_TR_INF("Current(mA) = %u (short)",tU16antennaCurrent);

      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START+0,(tU8) (tU16antennaCurrent >> 8));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START+1,(tU8) (tU16antennaCurrent & 0x00FF));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_GNSSAntennaCurrent_Get::vOnGNSSAntennaCurrentResponse SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_GNSSAntennaCurrent_Get::vOnGNSSAntennaCurrentResponse FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void dia_SrvHandler_GNSSAntennaCurrent_Get::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_GNSSAntennaCurrent_Get::vOnTimeout(void)");
   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();
}

