/*!
 * \file       dia_SrvHandler_ECUUniqueFieldDataId.h
 *
 * \brief      Read Unique FieldData ID or generate it if not existing
 *
 * \component  Diagnostics
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_ECUUNIQUEFIELDDATAID_H__
#define __INCLUDED_DIA_ECUUNIQUEFIELDDATAID_H__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

class dia_SrvHandler_ECUUniqueFieldDataId : public dia_ServiceHandlerUDS
{
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ECUUniqueFieldDataId);

  public:
    //! class constructor
    dia_SrvHandler_ECUUniqueFieldDataId() : dia_ServiceHandlerUDS("dia_SrvHandler_ECUUniqueFieldDataId"){};

    virtual tVoid vProcessRequest(const std::vector<tArgsType>&);
    virtual tDiaResult makeLookupKeys(std::vector<dia_LookupKey*>&);

  protected:
    //! class destructor
    virtual ~dia_SrvHandler_ECUUniqueFieldDataId(){};

  private:
    tDiaResult readUniqueFieldDataId(std::vector<uint8_t>& uniqueFieldDataId);
    tDiaResult generateUniqueFieldDataId(std::vector<uint8_t>& uniqueFieldDataId);
};

#endif /* __INCLUDED_DIA_ECUUNIQUEFIELDDATAID_H__ */
