/*
 * dia_SrvHandler_Disp_BrightnessInfo_Get.cpp
 *
 *  Created on: 29.08.2012
 *      Author: bhs1hi
 */
// TTFis:\> DIA_REQ UDS 03 22 62 03

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SrvHandler_Disp_BrightnessInfo_Get.h"

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_Disp_BrightnessInfo_Get::dia_SrvHandler_Disp_BrightnessInfo_Get ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_Disp_BrightnessInfo_Get",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_DISPLAY_BACKLIGHT_ILLUMINATION /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_Disp_BrightnessInfo_Get::dia_SrvHandler_Disp_BrightnessInfo_Get(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_Disp_BrightnessInfo_Get::~dia_SrvHandler_Disp_BrightnessInfo_Get ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_Disp_BrightnessInfo_Get::~dia_SrvHandler_Disp_BrightnessInfo_Get !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_Disp_BrightnessInfo_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_Disp_BrightnessInfo_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IDimming* pInterface = 0;
   if ( querySysAdapterInterface<dia_IDimming>(&pInterface) == DIA_SUCCESS )
   {
   	DIA_TR_INF("dia_SrvHandler_Disp_BrightnessInfo_Get::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
      	DIA_TR_INF("dia_SrvHandler_Disp_BrightnessInfo_Get::vProcessRequest - pInterface OK");
      	(tVoid) setSysAdapterListener<dia_IDimmingListener>(this);
         if ( pInterface->getDispBrightnessInformation() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         } else {
         	DIA_TR_INF("dia_SrvHandler_Disp_BrightnessInfo_Get::vProcessRequest - getDispBrightnessInformation() failed.");
         }
         DIA_TR_INF("dia_SrvHandler_Disp_BrightnessInfo_Get::vProcessRequest - check SA connection %d",pInterface->getUID() );
      }
   } else {
   	DIA_TR_INF("dia_SrvHandler_Disp_BrightnessInfo_Get::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
      DIA_TR_ERR(" ---  SEND TO SPM SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_Disp_BrightnessInfo_Get::vOnDispBrightnessInformation ( tU16 brightness )
{
   dia_tclFnctTrace trc("dia_SrvHandler_Disp_BrightnessInfo_Get:vOnDispBrightnessInformation");

   if ( brightness <= 1000 )
   {
      // DIA_TR_INF("vOnDispBrightnessInformation: Request OK");
      (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);

      // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) (brightness >> 8)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, (((tU8) brightness)));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_Disp_BrightnessInfo_Get::vOnDispBrightnessInformation SUCCESSFUL");
   }
   else {
      DIA_TR_INF("dia_SrvHandler_Disp_BrightnessInfo_Get::vOnDispBrightnessInformation FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

