/**
 * \file    dia_SrvHandler_CustomerAndBuildSWVersion_Write.h
 *
 * \brief   This file contains the definition of the dia_SrvHandler_CustomerAndBuildSWVersion_Write class,
 *          that provides a generic service handler that can be used to process
 *          write requests for the ConfigManager.
 *
 * \author  sta8hi
 * \date    2012/10/24
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#ifndef DIA_SERHANDLER_CUSTOMERANDBUILDSWVERSION_WRITE_H_
#define DIA_SERHANDLER_CUSTOMERANDBUILDSWVERSION_WRITE_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

/**
 * \class   dia_SrvHandler_CustomerAndBuildSWVersion_Write
 *
 * \brief   Generic service handler to process Identification request
 *
 *          This class provides a generic service handler that can be used to process
 *          identification requests that need to write one or more properties into
 *          the ConfigManager module.
 *
 * \ingroup diaServicesCommon
 */

class dia_SrvHandler_CustomerAndBuildSWVersion_Write
    : public dia_ServiceHandlerUDS
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandler_CustomerAndBuildSWVersion_Write);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_CustomerAndBuildSWVersion_Write);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    */
   dia_SrvHandler_CustomerAndBuildSWVersion_Write ( tCString name, tU8 sid, tU16 did );

   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandler_CustomerAndBuildSWVersion_Write ( tVoid );

   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    *
    * \return     none
    */
   virtual tVoid vProcessRequest ( const std::vector<tArgsType>& vecArgs );

private:

};


#endif /* dia_SrvHandler_WRITECUSTOMERSWVERSION_H_ */
