/*
 * dia_SrvHandler_AudioSourceActiveGet.cpp
 *
 *  Created on: 29.11.2012
 *      Author: gib2hi
 *
 ------------------------------------------------------------------------------------------------------------
 * date               author               modification
 * 15/12/2015         bma9kor            modified vOnAudioSourceList for DRM and ECALL
 * 26/10/2016         hld5kor            modified vOnAudioSourceList for DCM
 * 01/11/2016         maj9kor            modified vOnAudioSourceList for MICROPHONE2
 --------------------------------------------------------------------------------------------------------------
 *
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_AUDIO_SOURCE_ACTIVE_GET__
#include "dia_SrvHandler_AudioSourceActiveGet.h"
#endif

#ifndef __INCLUDED_DIA_AUDIO_MANAGER__
#include <common/framework/platform/cmd/dia_AudioManager.h>
#endif

static const tU16 DATA_START  = 3;
static const tU16 DATA_LENGTH = 1;

//-----------------------------------------------------------------------------

dia_SrvHandler_AudioSourceActiveGet::dia_SrvHandler_AudioSourceActiveGet ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandler_AudioSourceActiveGet", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_AUDIO_SOURCE_ACTIVE )
{
   dia_tclFnctTrace trc("dia_SrvHandler_AudioSourceActiveGet::dia_SrvHandler_AudioSourceActiveGet(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_AudioSourceActiveGet::~dia_SrvHandler_AudioSourceActiveGet ( void )
{}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_AudioSourceActiveGet::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_AudioSourceActiveGet::vProcessRequest");

   if ( getInstanceOfAudioManager()->getAudioSource(*this) != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_SrvHandler_AudioSourceActiveGet --- SEND TO AUDIO MANAGER SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

void
dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult ( dia_eAudioSource sourceID )
{
   dia_tclFnctTrace trc("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult");

   getInstanceOfAudioManager()->resetClient();

   DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult sourceID = %d", sourceID);

   tU8 audioSourceCDD = 0xFF;
#ifdef __DIA_NEW_AUDIO_SOURCE_SWITCHING_FSM__
   DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult __DIA_NEW_AUDIO_SOURCE_SWITCHING_FSM__");
   std::map<tU8,dia::AudioSourceMatcher>& audioSourceMappers = dia::AudioManager::getSourceMappings();
   std::map<tU8,dia::AudioSourceMatcher>::iterator iter = audioSourceMappers.begin();
   if(sourceID != DIA_EN_AUDIO_SOURCE_UNKNOWN)
   {
      for(;iter!=audioSourceMappers.end();iter++)
      {
         if(sourceID == iter->second.mSrcID)
         {
            audioSourceCDD = iter->first;
            DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult (%s)= 0x%02x is set", iter->second.mNamePattern.c_str() ,audioSourceCDD);
            break;
         }
      }
   }
   if(audioSourceCDD == 0xFF){
      DIA_TR_ERR("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult => UNKNOWN audioSrc=0x%02x !", sourceID);
   }
#else
   switch ( sourceID )
   {
   case DIA_EN_AUDIO_SOURCE_AUX_1:
      audioSourceCDD = 0x0E;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_AUX_1 = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_AUX_2:
      audioSourceCDD = 0x0F;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_AUX_2 = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_TUNER_AM:
      audioSourceCDD = 0x00;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_TUNER_AM = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_TUNER_DAB:
      audioSourceCDD = 0x03;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_TUNER_DAB = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_TUNER_FM:
      audioSourceCDD = 0x01;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_TUNER_FM = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_TUNER_TA_DAB:
      audioSourceCDD = 0x12;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_TUNER_TA_DAB = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_TUNER_TA_FM:
      audioSourceCDD = 0x13;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_TUNER_TA_FM = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_TUNER_XM:
      audioSourceCDD = 0x04;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_TUNER_XM = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_MEDIA_CDDA:
      audioSourceCDD = 0x0A;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_MEDIA_CDDA = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_MEDIA_PLAYER:
      audioSourceCDD = 0x09;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_MEDIA_PLAYER = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_NAVI_SPEECH:
      audioSourceCDD = 0x14;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_NAVI_SPEECH = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_PHONE:
      audioSourceCDD = 0x10;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_PHONE = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_PHONE_BTAUDIO:
      audioSourceCDD = 0x11;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_PHONE_BTAUDIO = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_PHONE_ECALL:
      audioSourceCDD = 0x16;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_PHONE_ECALL = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_MICROPHONE:
      audioSourceCDD = 0x07;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_MICROPHONE = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_TUNER_DRM:
      audioSourceCDD = 0x15;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_TUNER_DRM = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_DCM:
      audioSourceCDD = 0x0C;
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SOURCE_DCM = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_MICROPHONE2:
      audioSourceCDD = 0x17;  //Value from PD-CDD.
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult MICROPHONE2 = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_ENTERTAIN_EXT_CD:
      audioSourceCDD = 0x18;  //Value from PD-CDD (CMAudioSource)
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult EXT_CD = 0x%02x is set.", audioSourceCDD);
      break;
   case DIA_EN_AUDIO_SOURCE_ENTERTAIN_SPARE_CD:
      audioSourceCDD = 0x19;  //Value from PD-CDD (CMAudioSource)
      DIA_TR_INF("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult SPARE_CD = 0x%02x is set.", audioSourceCDD);
      break;
   default:
      DIA_TR_ERR("dia_SrvHandler_AudioSourceActiveGet::onAudioSourceGetResult => UNKNOWN audioSrc=0x%02x !", sourceID);
      break;
   }
#endif

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, audioSourceCDD);
   vResReadyAndQuit();
}

void
dia_SrvHandler_AudioSourceActiveGet::vOnTimeout ( void )
{
   dia_tclFnctTrace trc("dia_SrvHandler_AudioSourceActiveGet::vOnTimeout");
   getInstanceOfAudioManager()->resetClient();

   vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
}
