/*
 * dia_RtCtrlresetSystemResetInformation.cpp
 *
 *  Created on: 22.08.2012
 *      Author: gib2hi
 */
// TTFis:\>DIA_REQ UDS 05 31 01 D0 11

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#include "dia_RtCtrlresetSystemResetInformation.h"

namespace dia
{

//------------------------------------------------------------------------------

RtCtrlresetSystemResetInformation::RtCtrlresetSystemResetInformation ( tVoid )
   : dia_Routine("RtCtrlresetSystemResetInformation",
         (tU16) DIA_C_U16_DID_RBCM_RTCTRL_RESET_SYSTEM_RESET_INFORMATION,
         DIA_EN_RTCTRL_ID_RESET_SYSTEM_RESET_INFORMATION,
         DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
   dia_tclFnctTrace oTrace("RtCtrlresetSystemResetInformation::RtCtrlresetSystemResetInformation()");
}

//------------------------------------------------------------------------------

RtCtrlresetSystemResetInformation::~RtCtrlresetSystemResetInformation ( tVoid )
{}

//------------------------------------------------------------------------------

tDiaResult
RtCtrlresetSystemResetInformation::start ( std::vector<tU8>& /*params*/, tU8 /*timerValue*/ )
{
      dia_tclFnctTrace trc("RtCtrlresetSystemResetInformation::start");

      // prepare processing of the routine
      vInitialize();

      tBool errorDetected = TRUE;

      dia_ISpm* pInterface = OSAL_NULL;
      tDiaResult diaResult = querySysAdapterInterface<dia_ISpm>(&pInterface);

      if (diaResult == DIA_SUCCESS) {
         if (pInterface) {
            (tVoid) setSysAdapterListener<dia_ISpmListener>(this);

            if (pInterface->resetSystemResetInformation() == DIA_SUCCESS) {
               errorDetected = FALSE;
            } else {
               DIA_TR_ERR("dia_RtCtrlresetSystemResetInformation --- SEND TO SPM SERVER FAILED!!!!");
            }
         }
      }


   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_RtCtrlresetSystemResetInformation::start - errorDetected!");
      // currently we only have a dummy implementation
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }

   //! indicate that we are done -> not necessary for short rtctrl
//   mIsResultReady = TRUE;

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
RtCtrlresetSystemResetInformation::requestResult ( std::vector<tU8>& results )
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tVoid RtCtrlresetSystemResetInformation::vOnResetSystemResetStatus(tDiaResult success)
{
   dia_tclFnctTrace oTrace("dia_RtCtrlresetSystemResetInformation::vOnResetSystemResetStatus()");

   if (success == DIA_SUCCESS) {
      // currently we only have a dummy implementation
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
      DIA_TR_INF("dia_RtCtrlresetSystemResetInformation::vOnResetSystemResetStatus COMPLETED OK.");
   } else {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
      DIA_TR_INF("dia_RtCtrlresetSystemResetInformation::vOnResetSystemResetStatus COMPLETED NOK!");
   }

   mIsResultReady = TRUE;
   (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

} // namespace dia
